package app.valuationcontrol.webservice.model.events.listeners.logger;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.listeners.AuditLog;
import app.valuationcontrol.webservice.model.logentry.LogEntryRepository;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ModelLogger {
  private final LogEntryRepository logEntryRepository;

  public ModelLogger(LogEntryRepository logEntryRepository) {
    this.logEntryRepository = logEntryRepository;
  }

  @EventListener
  public void onEvent(Event<Model> event) {
    // Event<Model> event = (Event<Model>) genericEvent;
    switch (event.getType()) {
      case CREATED -> AuditLog.log(
          this.logEntryRepository,
          event.getNewVersion(),
          "Added model " + event.getNewVersion().getName(),
          event.getPrincipal());
      case UPDATED, METADATA_UPDATE -> AuditLog.log(
          this.logEntryRepository,
          event.getNewVersion(),
          "Updated model " + event.getNewVersion().getName(),
          event.getPrincipal());
      case DELETED -> {}
    }
  }
}
