package app.valuationcontrol.webservice.model.logentry;

import static app.valuationcontrol.webservice.helpers.EntityDTOConverter.asData;
import static app.valuationcontrol.webservice.model.ModelController.MODEL_ID;
import static org.springframework.http.ResponseEntity.ok;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LogEntryController {

  private final LogEntryRepository logEntryRepository;

  public LogEntryController(LogEntryRepository logEntryRepository) {
    this.logEntryRepository = logEntryRepository;
  }

  @GetMapping(value = "/api/model/{modelId}/logentry")
  @PreAuthorize("authentication.principal.hasModelRole(#model,'READER')")
  public ResponseEntity<List<LogEntryData>> getLogs(
      @PathVariable(value = MODEL_ID) Model model, Pageable pageable) {
    final List<LogEntry> allByModel =
        logEntryRepository.findAllByModel(model.getModelId(), pageable);
    allByModel.forEach(
        logEntry -> logEntry.setPeriod(Sensitivity.asModelYear(logEntry.getPeriod(), model)));
    return ok(asData(allByModel));
  }
}
