package app.valuationcontrol.webservice.model.logentry;

import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface LogEntryRepository extends JpaRepository<LogEntry, Long> {

  @Query("select l from LogEntry l where l.attachedModel.id = :modelId")
  List<LogEntry> findAllByModel(long modelId, Pageable pageable);
}
