package app.valuationcontrol.webservice.securityhelpers;

import app.valuationcontrol.webservice.user.User;
import app.valuationcontrol.webservice.user.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name = "mockuserservice", havingValue = "true")
public class AutoCreateUserDetailsService extends MyUserDetailsService {

  @Autowired
  public AutoCreateUserDetailsService(UserRepository userRepository) {
    super(userRepository);
  }

  @Override
  public UserDetails loadUserByUsername(String username) {
    try {
      return super.loadUserByUsername(username);
    } catch (UsernameNotFoundException e) {
      // For tests running against uninitialized dbs the user does not exist so we create it.

      User user = new User();
      user.setEmail(username);

      try {
        user = this.userRepository.save(user);
      } catch (Exception ex) {
        return new MyUserPrincipal(user);
      }
      return new MyUserPrincipal(user);
    }
  }
}
