package app.valuationcontrol.webservice.xlhandler;

public interface GenericSheet {

  void computeCellValues(CellValue... cellValues);

  record CellValue(double value, int column, int row) {}

  String getName();

  void setFormula(String formula, int column, int row);

  void setCellValues(CellValue... cellValues);

  void setValue(String[][] values, int columns, int rows);

  double getValue(int column, int row);

  double getValueWithoutRecalculation(int column, int row);

  void computeCalculations();

  void computeCell(int column, int row);

  Object[][] getValues(int endColumn, int endRow);

  String getErrorInCell(int column, int row);

  void setRowValues(int row, String[] data);
}
