/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.enin;

import app.valuationcontrol.webservice.enin.records.BalanceSheetRecord;
import app.valuationcontrol.webservice.enin.records.CompanyNameRecord;
import app.valuationcontrol.webservice.enin.records.EninCompanyDescriptionRecord;
import app.valuationcontrol.webservice.enin.records.EninCompanyRecord;
import app.valuationcontrol.webservice.enin.records.IncomeStatementRecord;
import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class EninAPIService {
    @Autowired
    private WebClient webClientAnalysis;
    @Autowired
    private WebClient webClientDataset;
    private final String API_PREFIX = "https://api.enin.ai/analysis/v1/";
    private final String API_DATASET_PREFIX = "https://api.enin.ai/datasets/v1/";

    private <M> M getAnalysisRecords(Class<M> parameterClass, String requestUri) {
        try {
            return (M)this.webClientAnalysis.get().uri(requestUri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(parameterClass).block();
        }
        catch (Exception e) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Couldn't reach ENIN api for " + requestUri);
        }
    }

    private <M> M getDatasetRecords(Class<M> parameterClass, String requestUri) {
        try {
            return (M)this.webClientDataset.get().uri(requestUri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono(parameterClass).block();
        }
        catch (Exception e) {
            throw new ResourceException(HttpStatus.BAD_REQUEST, "Couldn't reach ENIN api for " + requestUri);
        }
    }

    public CompanyNameRecord[] getCompanies(String companyName) {
        String requestUri = "https://api.enin.ai/datasets/v1/dataset/company-name-composite?company_name.name=ILIKE:%" + companyName + "%&keep_only_fields=company.name,company.org_nr,company.org_nr_schema,company_details.latest_accounting_year&limit=15";
        return (CompanyNameRecord[])this.getDatasetRecords(CompanyNameRecord[].class, requestUri);
    }

    public IncomeStatementRecord[] getIncomeStatement(String companyNumber, boolean doImportGroupFigures) {
        String requestUri = "https://api.enin.ai/analysis/v1/company/" + companyNumber + "/accounts-income-statement?accounts_type_identifier=annual_corporate_group_accounts";
        String requestUriSolo = "https://api.enin.ai/analysis/v1/company/" + companyNumber + "/accounts-income-statement";
        IncomeStatementRecord[] incomeStatementRecords = (IncomeStatementRecord[])this.getAnalysisRecords(IncomeStatementRecord[].class, doImportGroupFigures ? requestUri : requestUriSolo);
        if (incomeStatementRecords.length == 0 && doImportGroupFigures) {
            incomeStatementRecords = (IncomeStatementRecord[])this.getAnalysisRecords(IncomeStatementRecord[].class, requestUriSolo);
        }
        return incomeStatementRecords;
    }

    public BalanceSheetRecord[] getBalanceSheet(String companyNumber, boolean doImportGroupFigures) {
        String requestUri = "https://api.enin.ai/analysis/v1/company/" + companyNumber + "/accounts-balance-sheet?accounts_type_identifier=annual_corporate_group_accounts";
        String requestUriSolo = "https://api.enin.ai/analysis/v1/company/" + companyNumber + "/accounts-balance-sheet";
        BalanceSheetRecord[] balanceSheetRecord = (BalanceSheetRecord[])this.getAnalysisRecords(BalanceSheetRecord[].class, doImportGroupFigures ? requestUri : requestUriSolo);
        if (balanceSheetRecord.length == 0 && doImportGroupFigures) {
            balanceSheetRecord = (BalanceSheetRecord[])this.getAnalysisRecords(BalanceSheetRecord[].class, requestUriSolo);
        }
        return balanceSheetRecord;
    }

    public EninCompanyDescriptionRecord[] getDescription(String companyNumber) {
        String requestUri = "https://api.enin.ai/analysis/v1/company/" + companyNumber + "/company-description?company_description_type_identifier=brreg_official_purpose";
        return (EninCompanyDescriptionRecord[])this.getAnalysisRecords(EninCompanyDescriptionRecord[].class, requestUri);
    }

    public EninCompanyRecord getCompanyRecord(String companyNumber, boolean doImportGroupFigures) {
        if (companyNumber.toUpperCase().matches("NO[0-9]{9}")) {
            return new EninCompanyRecord(companyNumber, this.getDescription(companyNumber)[0], this.getIncomeStatement(companyNumber, doImportGroupFigures), this.getBalanceSheet(companyNumber, doImportGroupFigures));
        }
        throw new ResourceException(HttpStatus.BAD_REQUEST, "Company number is not valid");
    }
}

