/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.helpers;

import app.valuationcontrol.webservice.model.Model;
import java.util.Objects;

public record DataPeriod(Model myModel, Integer periodOffset, Integer segmentOffsetFactor, boolean isConstant) {
    private final Model myModel;
    private final Integer periodOffset;
    private final Integer segmentOffsetFactor;
    private final boolean isConstant;

    public DataPeriod(Model myModel, Integer periodOffset, Integer segmentOffsetFactor, boolean isConstant) {
        this.myModel = myModel;
        this.periodOffset = periodOffset;
        this.segmentOffsetFactor = segmentOffsetFactor;
        this.isConstant = isConstant;
    }

    public Integer getTotalOffsetAsInteger() {
        return Objects.requireNonNullElse(this.periodOffset, 0) + this.segmentOffsetFactor * this.myModel.getNumberOfPeriodsAndValue();
    }

    public Integer getColumn() {
        if (this.isConstant) {
            return this.myModel.getConstantColumn() + this.getSegmentOffsetAsInteger();
        }
        return this.myModel.getConstantColumn() + this.myModel.getNbHistoricalPeriod() + 1 + this.getTotalOffsetAsInteger();
    }

    public Integer getSegmentOffsetAsInteger() {
        return this.segmentOffsetFactor * this.myModel.getNumberOfPeriodsAndValue();
    }

    public Integer lowBound() {
        return -this.myModel.getNbHistoricalPeriod().intValue();
    }

    public Integer highBound() {
        return this.myModel.getNbProjectionPeriod() - 1;
    }

    public boolean isWithinBound(Integer periodToCheck) {
        return periodToCheck >= this.lowBound() && periodToCheck <= this.highBound();
    }

    public DataPeriod previousPeriod() {
        return new DataPeriod(this.myModel, Integer.valueOf(this.periodOffset - 1), this.segmentOffsetFactor, this.isConstant);
    }

    public Model myModel() {
        return this.myModel;
    }

    public Integer periodOffset() {
        return this.periodOffset;
    }

    public Integer segmentOffsetFactor() {
        return this.segmentOffsetFactor;
    }

    public boolean isConstant() {
        return this.isConstant;
    }
}

