/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events;

import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.ResolvableType;
import org.springframework.core.ResolvableTypeProvider;

public class Event<T>
extends ApplicationEvent
implements ResolvableTypeProvider {
    private static final Logger log = LogManager.getLogger(Event.class);
    private final T old;
    private final T updated;
    private final Principal principal;
    private final Model model;
    private final Class<?> parameterClass;

    public Event(Object source, T old, T updated, Principal principal, Class<?> parameterClass, Model model) {
        super(source);
        this.old = old;
        this.updated = updated;
        this.principal = principal;
        this.parameterClass = parameterClass;
        this.model = model;
    }

    public T getOldVersion() {
        return (T)this.old;
    }

    public T getNewVersion() {
        return (T)this.updated;
    }

    public ResolvableType getResolvableType() {
        return ResolvableType.forClassWithGenerics(this.getClass(), (Class[])new Class[]{this.parameterClass});
    }

    public String getParameterClass() {
        return this.parameterClass.getSimpleName();
    }

    public EVENT_TYPE getType() {
        if (this.isCreate()) {
            return EVENT_TYPE.CREATED;
        }
        if (this.isDelete()) {
            return EVENT_TYPE.DELETED;
        }
        if (this.isMetadataUpdate()) {
            return EVENT_TYPE.METADATA_UPDATE;
        }
        return EVENT_TYPE.UPDATED;
    }

    public T effectedEntity() {
        return (T)(this.isCreate() || this.isUpdate() ? this.getNewVersion() : this.getOldVersion());
    }

    public boolean isCreate() {
        return this.old == null && this.updated != null;
    }

    public boolean isUpdate() {
        return this.old != null && this.updated != null;
    }

    public boolean isMetadataUpdate() {
        return this.old != null && this.old.equals(this.updated);
    }

    public boolean isDelete() {
        return this.old != null && this.updated == null;
    }

    public static <M> Event<M> created(Object source, M created, Principal principal, Class<?> parameterClass, Model model) {
        return new Event(source, null, created, principal, parameterClass, model);
    }

    public static <M> Event<M> updated(Object source, M old, M updated, Principal principal, Class<?> parameterClass, Model model) {
        return new Event(source, old, updated, principal, parameterClass, model);
    }

    public static <M> Event<M> lightUpdated(Object source, M updated, Principal principal, Class<?> parameterClass, Model model) {
        return new Event(source, updated, updated, principal, parameterClass, model);
    }

    public static <M> Event<M> deleted(Object source, M old, Principal principal, Class<?> parameterClass, Model model) {
        return new Event(source, old, null, principal, parameterClass, model);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Model getModel() {
        return this.model;
    }
}

