/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.user.User;
import app.valuationcontrol.webservice.user.UserRepository;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ConnectUserToModelWhenCreated {
    private static final Logger log = LogManager.getLogger(ConnectUserToModelWhenCreated.class);
    private final EntityService entityService;
    private final UserRepository userRepository;

    public ConnectUserToModelWhenCreated(EntityService entityService, UserRepository userRepository) {
        this.entityService = entityService;
        this.userRepository = userRepository;
    }

    @EventListener
    public void onEvent(Event<Model> event) {
        if (event.isCreate()) {
            this.connectToUser((Model)event.getNewVersion(), event.getPrincipal());
        }
    }

    private void connectToUser(Model newModel, Principal principal) {
        User byEmail = this.userRepository.findByEmail(principal.getName());
        if (byEmail == null) {
            log.warn("User {} could not be found", (Object)principal.getName());
            byEmail = new User();
            byEmail.setEmail(principal.getName());
        }
        byEmail.addModel(newModel, User.MODEL_ROLE.ADMIN);
        this.entityService.safeUpdate(User.class, (Object)byEmail, (Object)byEmail, new ModelProvider[0]);
    }
}

