/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.events.listeners;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.FormulaEvaluator;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.variable.Variable;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class VariableNameChangeListener {
    private static final Logger log = LogManager.getLogger(VariableNameChangeListener.class);
    private static final String WORD_BOUNDARY = "\\b";
    public static final String ZERO_OR_MORE_CHARACTERS = ".*";
    private final EntityService entityService;

    public VariableNameChangeListener(EntityService entityService) {
        this.entityService = entityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    private void handleEvent(Event<Variable> variableEvent) {
        if (this.isNameChanged(variableEvent)) {
            Variable myNewVariable = (Variable)variableEvent.getNewVersion();
            List dependants = this.getDependants(myNewVariable);
            List<Pair> pairs = dependants.stream().map(variable -> {
                Variable oldVariable = new Variable(variable);
                this.updateFormula(variable);
                return Pair.of((Object)oldVariable, (Object)variable);
            }).toList();
            this.entityService.updateAll(Variable.class, pairs);
        }
        if (variableEvent.isCreate()) {
            Variable createdVariable = (Variable)variableEvent.getNewVersion();
            createdVariable.getAttachedModel().getVariables().add(createdVariable);
            try {
                String variableName = VariableNameChangeListener.contains((String)VariableNameChangeListener.exactWord((String)createdVariable.getVariableName().toLowerCase(Locale.ROOT)));
                List<Pair> variablesDependingOnCreatedVariable = createdVariable.getAttachedModel().getVariables().stream().filter(variable -> variable.getEvaluatedVariableFormula() != null).filter(variable -> variable.getEvaluatedVariableFormula().matches(variableName)).map(variable -> {
                    Variable oldVariable = new Variable(variable);
                    variable.setEvaluatedVariableFormula(FormulaEvaluator.evaluateVariableFormula((Variable)variable));
                    return Pair.of((Object)oldVariable, (Object)variable);
                }).toList();
                if (!variablesDependingOnCreatedVariable.isEmpty()) {
                    this.entityService.updateAll(Variable.class, variablesDependingOnCreatedVariable);
                }
            }
            finally {
                createdVariable.getAttachedModel().getVariables().remove(createdVariable);
            }
        }
    }

    private void updateFormula(Variable variable) {
        if (variable.getEvaluatedVariableFormula() != null) {
            String tempFormula = variable.getEvaluatedVariableFormula();
            for (Variable variableDependency : variable.getVariableDependencies()) {
                tempFormula = tempFormula.replaceAll("\\{" + variableDependency.getId() + "\\}", variableDependency.getVariableName());
            }
            variable.setVariableFormula(tempFormula);
        }
    }

    public static String exactWord(String variableName) {
        return "\\b" + variableName + "\\b";
    }

    public static String contains(String value) {
        return ".*" + value + ".*";
    }

    private List<Variable> getDependants(Variable variable) {
        return variable.getAttachedModel().getVariables().stream().filter(otherVariable -> otherVariable.getVariableDependencies().stream().mapToLong(Variable::getId).anyMatch(value -> value == variable.getId())).toList();
    }

    private boolean isNameChanged(Event<Variable> variableEvent) {
        return variableEvent.isUpdate() && !((Variable)variableEvent.getOldVersion()).getVariableName().equals(((Variable)variableEvent.getNewVersion()).getVariableName());
    }
}

