/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.sensitivity;

import app.valuationcontrol.webservice.EntityService;
import app.valuationcontrol.webservice.helpers.ModelChecker;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.events.Event;
import app.valuationcontrol.webservice.model.events.Events;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityData;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import app.valuationcontrol.webservice.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.webservice.xlhandler.XLHandleManager;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import java.security.Principal;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
public class SensitivityController {
    private final XLHandleManager xlHandleManager;
    private final EntityService entityService;
    private final Events events;

    @Autowired
    public SensitivityController(XLHandleManager xlHandleManager, EntityService entityService, Events events) {
        this.xlHandleManager = xlHandleManager;
        this.entityService = entityService;
        this.events = events;
    }

    @PostMapping(value={"/api/model/{modelId}/sensitivity"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<Long> addSensitivity(@PathVariable(value="modelId") Model model, @Valid @RequestBody SensitivityData sensitivityData, Principal principal) {
        Sensitivity sensitivity = new Sensitivity(sensitivityData, model);
        model.getSensitivities().add(sensitivity);
        return this.entityService.safeCreate(Sensitivity.class, (Object)sensitivity, new ModelProvider[0]).map(createdSensitivity -> {
            Event event = Event.created((Object)this, (Object)createdSensitivity, (Principal)principal, Sensitivity.class, (Model)model);
            this.events.publishCustomEvent(event);
            this.events.processEvents(principal);
            return new ResponseEntity((Object)createdSensitivity.getId(), (HttpStatusCode)HttpStatus.CREATED);
        }).orElse(ResponseEntity.badRequest().build());
    }

    @PutMapping(value={"/api/model/{modelId}/sensitivity/{sensitivityId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> updateSensitivity(@PathVariable(value="modelId") Model model, @PathVariable(value="sensitivityId") Sensitivity existingSensitivity, @Valid @RequestBody SensitivityData sensitivityData, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, existingSensitivity})) {
            return ResponseEntity.badRequest().build();
        }
        Sensitivity oldSensitivity = new Sensitivity(existingSensitivity);
        existingSensitivity.updateWith(sensitivityData);
        Event event = Event.updated((Object)this, (Object)oldSensitivity, (Object)existingSensitivity, (Principal)principal, Sensitivity.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok((Object)String.valueOf(existingSensitivity.getId()));
    }

    @DeleteMapping(value={"/api/model/{modelId}/sensitivity/{sensitivityId}"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'EDITOR')")
    public ResponseEntity<String> deleteSensitivity(@PathVariable(value="modelId") Model model, @PathVariable(value="sensitivityId") Sensitivity sensitivity, Principal principal) {
        if (!ModelChecker.inSameModel((ModelProvider[])new ModelProvider[]{model, sensitivity})) {
            return ResponseEntity.badRequest().build();
        }
        model.getSensitivities().remove(sensitivity);
        Event event = Event.deleted((Object)this, (Object)sensitivity, (Principal)principal, Sensitivity.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/api/model/{modelId}/sensitivity/run"})
    @PreAuthorize(value="authentication.principal.hasModelRole(#model,'READER')")
    public ResponseEntity<String> runSensitivities(@PathVariable(value="modelId") Model model, @RequestParam(value="scenario_number") Integer scenarioNumber, Principal principal) {
        ScenarioDataProvider xlInstance = this.xlHandleManager.getXLInstanceForModel(model);
        int scenarioToRun = scenarioNumber != null ? scenarioNumber : 0;
        xlInstance.runSensitivities(model.getSensitivities(), SCENARIO.from((int)scenarioToRun));
        model.getSensitivities().forEach(sensitivity -> sensitivity.setSensitivityLastRun(LocalDateTime.now()));
        Event event = Event.lightUpdated((Object)this, (Object)model, (Principal)principal, Model.class, (Model)model);
        this.events.publishCustomEvent(event);
        this.events.processEvents(principal);
        return ResponseEntity.ok((Object)"");
    }
}

