/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.variable;

import app.valuationcontrol.webservice.helpers.DataPeriod;
import app.valuationcontrol.webservice.helpers.DataTransformer;
import app.valuationcontrol.webservice.helpers.EntityDTOConverter;
import app.valuationcontrol.webservice.helpers.FormulaEvaluator;
import app.valuationcontrol.webservice.helpers.ModelProvider;
import app.valuationcontrol.webservice.helpers.VariableReplacementOccurrence;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.area.Area;
import app.valuationcontrol.webservice.model.segment.Segment;
import app.valuationcontrol.webservice.model.subarea.SubArea;
import app.valuationcontrol.webservice.model.variable.VariableData;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.xlhandler.CellValueHelper;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"attached_model_id", "variableName"})})
public class Variable
implements DataTransformer<VariableData>,
ModelProvider {
    public static final String CONSTANT = "constant";
    private static final String SINGLE_RESULT = "single_result";
    public static final List<String> CONSTANT_OR_SINGLE = List.of("constant", "single_result");
    private static final List<String> NO_VALUE_VARIABLE_TYPES = List.of("sub_total_row", "total_row");
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String variableName;
    private String variableDescription;
    @Column(length=500)
    private String variableFormula;
    private String variableType;
    private Integer variableOrder;
    private Integer variableDepth;
    private boolean variableApplyToHistoricals;
    private String variableFormat;
    @Column(length=500)
    private String evaluatedVariableFormula;
    @ManyToOne
    private Area variableArea;
    @ManyToOne
    private SubArea variableSubArea;
    @ManyToOne
    private Model attachedModel;
    @OneToMany(mappedBy="attachedVariable", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VariableValue> variableValues = new ArrayList();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<Variable> variableDependencies = new ArrayList();
    @Transient
    private Long originalId;
    @Transient
    private List<Object[]> historicalValues;
    @Transient
    private List<Object[]> projectionValues;
    @Transient
    private List<Object> singleOrConstantValue = new ArrayList();
    @Transient
    private final List<Object> yearToDateValue = new ArrayList();
    @Transient
    private final List<Object> yearToGoValue = new ArrayList();
    @Transient
    private final List<VariableReplacementOccurrence> replacementOccurrences = new ArrayList();

    public Variable() {
    }

    public Variable(Variable existingVariable) {
        this.variableName = existingVariable.getVariableName();
        this.variableDescription = existingVariable.getVariableDescription();
        this.variableFormula = existingVariable.getVariableFormula();
        this.variableType = existingVariable.getVariableType();
        this.variableFormat = existingVariable.getVariableFormat();
        this.variableApplyToHistoricals = existingVariable.isVariableApplyToHistoricals();
        this.variableDepth = existingVariable.getVariableDepth();
        this.variableOrder = existingVariable.getVariableOrder();
        this.evaluatedVariableFormula = existingVariable.getEvaluatedVariableFormula();
        this.variableDependencies = existingVariable.getVariableDependencies();
        this.variableValues = existingVariable.getVariableValues();
        this.variableSubArea = existingVariable.getVariableSubArea();
        this.variableArea = this.variableSubArea.getAttachedArea();
        this.attachedModel = existingVariable.getAttachedModel();
    }

    public Variable(VariableData variableData, Model model, Area area, SubArea subArea) {
        this.attachedModel = model;
        this.updateFromVariableData(variableData, area, subArea);
        this.setVariableOrder(Integer.valueOf(model.getMaxVariableOrder() + 1));
    }

    public Variable(Variable templateVariable, SubArea variableSubArea) {
        this(templateVariable);
        this.evaluatedVariableFormula = null;
        this.variableDependencies = new ArrayList();
        this.variableValues = new ArrayList();
        this.variableSubArea = variableSubArea;
        this.variableArea = variableSubArea.getAttachedArea();
        this.attachedModel = variableSubArea.getAttachedArea().getAttachedModel();
    }

    public void updateFromVariableData(VariableData variableData, Area area, SubArea subArea) {
        this.setVariableFormula(variableData.variableFormula());
        this.setEvaluatedVariableFormula(FormulaEvaluator.evaluateVariableFormula((Variable)this));
        this.manageVariableValues(this.getVariableValues(), this.getVariableType(), variableData.variableType());
        this.setVariableType(variableData.variableType());
        this.setVariableName(variableData.variableName());
        this.setVariableDescription(variableData.variableDescription());
        this.setVariableDepth(variableData.variableDepth());
        this.setVariableApplyToHistoricals(variableData.variableApplyToHistoricals());
        this.setVariableFormat(variableData.variableFormat());
        this.setVariableArea(area);
        this.setVariableSubArea(subArea);
    }

    private void manageVariableValues(List<VariableValue> values, String oldVariableType, String newVariableType) {
        if (oldVariableType == null) {
            return;
        }
        if (NO_VALUE_VARIABLE_TYPES.contains(newVariableType)) {
            values.clear();
            return;
        }
        if (CONSTANT.contains(oldVariableType) && !CONSTANT.contains(newVariableType)) {
            values.clear();
            return;
        }
        if (!CONSTANT.contains(oldVariableType) && CONSTANT.contains(newVariableType)) {
            values.clear();
        }
    }

    public String generateHistoricalRange(DataPeriod dataPeriod) {
        Object returnRange;
        if (this.getAttachedModel().getNbHistoricalPeriod() > 0) {
            DataPeriod startDataPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(-this.attachedModel.getNbHistoricalPeriod().intValue()), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            String startRange = CellValueHelper.generateAddress((Variable)this, (DataPeriod)startDataPeriod);
            DataPeriod endDataPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(-1), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            String stopRange = CellValueHelper.generateAddress((Variable)this, (DataPeriod)endDataPeriod);
            returnRange = startRange + ":" + stopRange;
        } else {
            returnRange = "No historical periods";
        }
        return returnRange;
    }

    public String generateProjectionRange(DataPeriod dataPeriod) {
        Object returnRange;
        if (this.getAttachedModel().getNbProjectionPeriod() > 0) {
            DataPeriod startDataPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(0), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            String startRange = CellValueHelper.generateAddress((Variable)this, (DataPeriod)startDataPeriod);
            DataPeriod endDataPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(this.attachedModel.getNbProjectionPeriod() - 1), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            String stopRange = CellValueHelper.generateAddress((Variable)this, (DataPeriod)endDataPeriod);
            returnRange = startRange + ":" + stopRange;
        } else {
            returnRange = "No projection periods";
        }
        return returnRange;
    }

    public String generateAllPeriodsRange(DataPeriod dataPeriod) {
        Object returnRange;
        int backwardsOffset = 0;
        if (this.getAttachedModel().getNbProjectionPeriod() > 0) {
            if (this.getAttachedModel().getNbHistoricalPeriod() > 0) {
                backwardsOffset = -this.getAttachedModel().getNbHistoricalPeriod().intValue();
            }
            DataPeriod startDataPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(backwardsOffset), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            String startRange = CellValueHelper.generateAddress((Variable)this, (DataPeriod)startDataPeriod);
            DataPeriod endDataPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(this.attachedModel.getNbProjectionPeriod() - 1), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            String stopRange = CellValueHelper.generateAddress((Variable)this, (DataPeriod)endDataPeriod);
            returnRange = startRange + ":" + stopRange;
        } else {
            returnRange = "No projection periods";
        }
        return returnRange;
    }

    public String generateLastPeriodRange(DataPeriod dataPeriod) {
        if (this.getAttachedModel().getNbProjectionPeriod() > 0) {
            DataPeriod lastPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(this.attachedModel.getNbProjectionPeriod() - 1), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            return CellValueHelper.generateAddress((Variable)this, (DataPeriod)lastPeriod);
        }
        return "No projection periods";
    }

    public String generateFirstPeriodRange(DataPeriod dataPeriod) {
        if (this.getAttachedModel().getNbProjectionPeriod() > 0) {
            DataPeriod firstPeriod = new DataPeriod(this.attachedModel, Integer.valueOf(0), dataPeriod.segmentOffsetFactor(), this.isSingleOrConstantValue());
            return CellValueHelper.generateAddress((Variable)this, (DataPeriod)firstPeriod);
        }
        return "No projection periods";
    }

    public List<VariableValue> getVariableValuesForAScenario(SCENARIO scenario) {
        return this.getVariableValues().stream().filter(variableValue -> variableValue.getScenarioNumber().intValue() == scenario.ordinal()).toList();
    }

    public boolean isSingleOrConstantValue() {
        return CONSTANT_OR_SINGLE.contains(this.getVariableType());
    }

    public int getPrimaryColumn() {
        if (this.isSingleOrConstantValue()) {
            return this.attachedModel.getConstantColumn();
        }
        return this.attachedModel.getFirstProjectionColumn();
    }

    public int getRow() {
        for (int i = 0; i < this.getAttachedModel().getVariables().size(); ++i) {
            if (!((Variable)this.getAttachedModel().getVariables().get(i)).getId().equals(this.getId())) continue;
            return i;
        }
        return -1;
    }

    public Long getVariableAreaId() {
        return this.variableArea.getId();
    }

    public Long getVariableSubAreaId() {
        return this.variableSubArea.getId();
    }

    public boolean isModelledAtSegment() {
        return this.variableSubArea.isModelledAtSegment();
    }

    public void addDependency(Variable variable) {
        this.variableDependencies.add(variable);
    }

    public VariableData asData() {
        return new VariableData(this.id, this.getVariableName(), this.getVariableDescription(), this.getVariableAreaId(), this.getVariableSubAreaId(), this.getVariableFormula(), this.getVariableType(), Integer.valueOf(this.getRow()), this.getVariableOrder(), this.getVariableDepth(), this.isVariableApplyToHistoricals(), this.getVariableFormat(), EntityDTOConverter.asData((List)this.getVariableValues()), this.getVariableDependencies().stream().map(Variable::getId).toList(), this.getEvaluatedVariableFormula(), this.getOriginalId(), "", this.historicalValues, this.projectionValues, this.isModelledAtSegment(), this.singleOrConstantValue, this.yearToDateValue, this.yearToGoValue);
    }

    public boolean isConstant() {
        return CONSTANT.equals(this.getVariableType());
    }

    public Long getModelId() {
        return this.getAttachedModel().getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            Variable variable = (Variable)obj;
            return Objects.equals(variable.getId(), this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int columnOfSegmentAndPeriod(int segmentIndex, Integer period) {
        if (this.isSingleOrConstantValue()) {
            period = 0;
        }
        if (period == -500) {
            period = this.getAttachedModel().getNbProjectionPeriod();
        }
        return new DataPeriod(this.attachedModel, period, Integer.valueOf(segmentIndex + 1), this.isSingleOrConstantValue()).getColumn();
    }

    public int columnOfSegmentAndPeriod(Segment segment, Integer period) {
        int segmentIndex = -1;
        if (segment != null) {
            segmentIndex = this.getAttachedModel().getSegments().indexOf(segment);
        }
        return this.columnOfSegmentAndPeriod(segmentIndex, period);
    }

    public boolean isPercentOrKPI() {
        return this.getVariableFormat().equals("percent") || this.getVariableType().equals("kpi");
    }

    public boolean isTypeTotal() {
        return NO_VALUE_VARIABLE_TYPES.contains(this.getVariableType());
    }

    public Long getId() {
        return this.id;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableDescription() {
        return this.variableDescription;
    }

    public String getVariableFormula() {
        return this.variableFormula;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public Integer getVariableOrder() {
        return this.variableOrder;
    }

    public Integer getVariableDepth() {
        return this.variableDepth;
    }

    public boolean isVariableApplyToHistoricals() {
        return this.variableApplyToHistoricals;
    }

    public String getVariableFormat() {
        return this.variableFormat;
    }

    public String getEvaluatedVariableFormula() {
        return this.evaluatedVariableFormula;
    }

    public Area getVariableArea() {
        return this.variableArea;
    }

    public SubArea getVariableSubArea() {
        return this.variableSubArea;
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public List<VariableValue> getVariableValues() {
        return this.variableValues;
    }

    public List<Variable> getVariableDependencies() {
        return this.variableDependencies;
    }

    public Long getOriginalId() {
        return this.originalId;
    }

    public List<Object[]> getHistoricalValues() {
        return this.historicalValues;
    }

    public List<Object[]> getProjectionValues() {
        return this.projectionValues;
    }

    public List<Object> getSingleOrConstantValue() {
        return this.singleOrConstantValue;
    }

    public List<Object> getYearToDateValue() {
        return this.yearToDateValue;
    }

    public List<Object> getYearToGoValue() {
        return this.yearToGoValue;
    }

    public List<VariableReplacementOccurrence> getReplacementOccurrences() {
        return this.replacementOccurrences;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setVariableDescription(String variableDescription) {
        this.variableDescription = variableDescription;
    }

    public void setVariableFormula(String variableFormula) {
        this.variableFormula = variableFormula;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public void setVariableOrder(Integer variableOrder) {
        this.variableOrder = variableOrder;
    }

    public void setVariableDepth(Integer variableDepth) {
        this.variableDepth = variableDepth;
    }

    public void setVariableApplyToHistoricals(boolean variableApplyToHistoricals) {
        this.variableApplyToHistoricals = variableApplyToHistoricals;
    }

    public void setVariableFormat(String variableFormat) {
        this.variableFormat = variableFormat;
    }

    public void setEvaluatedVariableFormula(String evaluatedVariableFormula) {
        this.evaluatedVariableFormula = evaluatedVariableFormula;
    }

    public void setVariableArea(Area variableArea) {
        this.variableArea = variableArea;
    }

    public void setVariableSubArea(SubArea variableSubArea) {
        this.variableSubArea = variableSubArea;
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    public void setVariableValues(List<VariableValue> variableValues) {
        this.variableValues = variableValues;
    }

    public void setVariableDependencies(List<Variable> variableDependencies) {
        this.variableDependencies = variableDependencies;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }

    public void setHistoricalValues(List<Object[]> historicalValues) {
        this.historicalValues = historicalValues;
    }

    public void setProjectionValues(List<Object[]> projectionValues) {
        this.projectionValues = projectionValues;
    }

    public void setSingleOrConstantValue(List<Object> singleOrConstantValue) {
        this.singleOrConstantValue = singleOrConstantValue;
    }
}

