/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.model.variable;

import app.valuationcontrol.webservice.model.EvenBrackets;
import app.valuationcontrol.webservice.model.EvenParenthesis;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variablevalue.VariableValueData;
import app.valuationcontrol.webservice.openai.OpenAIHelperFunctions;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;

public record VariableData(Long id, @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") String variableName, String variableDescription, Long variableAreaId, Long variableSubAreaId, @EvenParenthesis @EvenBrackets String variableFormula, @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableType, Integer row, Integer variableOrder, Integer variableDepth, boolean variableApplyToHistoricals, @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableFormat, List<VariableValueData> variableValues, List<Long> variableDependencies, String evaluatedVariableFormula, Long originalId, String evaluatedXLformula, List<Object[]> historicalValues, List<Object[]> projectionValues, boolean modelledAtSegment, List<Object> singleOrConstantValue, List<Object> yearToDateValue, List<Object> yearToGoValue) {
    private final Long id;
    @NotEmpty
    @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*")
    private final @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") String variableName;
    private final String variableDescription;
    private final Long variableAreaId;
    private final Long variableSubAreaId;
    @EvenParenthesis
    @EvenBrackets
    private final String variableFormula;
    @NotEmpty
    @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE})
    private final @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableType;
    private final Integer row;
    private final Integer variableOrder;
    private final Integer variableDepth;
    private final boolean variableApplyToHistoricals;
    @NotEmpty
    @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE})
    private final @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableFormat;
    private final List<VariableValueData> variableValues;
    private final List<Long> variableDependencies;
    private final String evaluatedVariableFormula;
    private final Long originalId;
    private final String evaluatedXLformula;
    private final List<Object[]> historicalValues;
    private final List<Object[]> projectionValues;
    private final boolean modelledAtSegment;
    private final List<Object> singleOrConstantValue;
    private final List<Object> yearToDateValue;
    private final List<Object> yearToGoValue;

    public VariableData(Long id, @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") String variableName, String variableDescription, Long variableAreaId, Long variableSubAreaId, String variableFormula, @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableType, Integer row, Integer variableOrder, Integer variableDepth, boolean variableApplyToHistoricals, @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableFormat, List<VariableValueData> variableValues, List<Long> variableDependencies, String evaluatedVariableFormula, Long originalId, String evaluatedXLformula, List<Object[]> historicalValues, List<Object[]> projectionValues, boolean modelledAtSegment, List<Object> singleOrConstantValue, List<Object> yearToDateValue, List<Object> yearToGoValue) {
        this.id = id;
        this.variableName = variableName;
        this.variableDescription = variableDescription;
        this.variableAreaId = variableAreaId;
        this.variableSubAreaId = variableSubAreaId;
        this.variableFormula = variableFormula;
        this.variableType = variableType;
        this.row = row;
        this.variableOrder = variableOrder;
        this.variableDepth = variableDepth;
        this.variableApplyToHistoricals = variableApplyToHistoricals;
        this.variableFormat = variableFormat;
        this.variableValues = variableValues;
        this.variableDependencies = variableDependencies;
        this.evaluatedVariableFormula = evaluatedVariableFormula;
        this.originalId = originalId;
        this.evaluatedXLformula = evaluatedXLformula;
        this.historicalValues = historicalValues;
        this.projectionValues = projectionValues;
        this.modelledAtSegment = modelledAtSegment;
        this.singleOrConstantValue = singleOrConstantValue;
        this.yearToDateValue = yearToDateValue;
        this.yearToGoValue = yearToGoValue;
    }

    public boolean isSingleEntry() {
        return Variable.CONSTANT_OR_SINGLE.contains(this.variableType);
    }

    public Double getValueInPeriod(Integer period, Integer segmentIndex) {
        if (this.isSingleEntry() && this.singleOrConstantValue.size() > 0) {
            return OpenAIHelperFunctions.getDoubleFromObject(this.singleOrConstantValue.get(segmentIndex), (VariableData)this);
        }
        if (period > 0 && !this.projectionValues().isEmpty() && this.projectionValues().get(segmentIndex) != null) {
            return OpenAIHelperFunctions.getDoubleFromObject((Object)((Object[])this.projectionValues.get(segmentIndex))[period], (VariableData)this);
        }
        if (period < 0 && !this.historicalValues().isEmpty() && this.historicalValues().get(segmentIndex) != null) {
            return OpenAIHelperFunctions.getDoubleFromObject((Object)((Object[])this.historicalValues.get(segmentIndex))[period], (VariableData)this);
        }
        return null;
    }

    public Long id() {
        return this.id;
    }

    @NotEmpty
    @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*")
    public @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") String variableName() {
        return this.variableName;
    }

    public String variableDescription() {
        return this.variableDescription;
    }

    public Long variableAreaId() {
        return this.variableAreaId;
    }

    public Long variableSubAreaId() {
        return this.variableSubAreaId;
    }

    public String variableFormula() {
        return this.variableFormula;
    }

    @NotEmpty
    @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE})
    public @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableType() {
        return this.variableType;
    }

    public Integer row() {
        return this.row;
    }

    public Integer variableOrder() {
        return this.variableOrder;
    }

    public Integer variableDepth() {
        return this.variableDepth;
    }

    public boolean variableApplyToHistoricals() {
        return this.variableApplyToHistoricals;
    }

    @NotEmpty
    @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE})
    public @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableFormat() {
        return this.variableFormat;
    }

    public List<VariableValueData> variableValues() {
        return this.variableValues;
    }

    public List<Long> variableDependencies() {
        return this.variableDependencies;
    }

    public String evaluatedVariableFormula() {
        return this.evaluatedVariableFormula;
    }

    public Long originalId() {
        return this.originalId;
    }

    public String evaluatedXLformula() {
        return this.evaluatedXLformula;
    }

    public List<Object[]> historicalValues() {
        return this.historicalValues;
    }

    public List<Object[]> projectionValues() {
        return this.projectionValues;
    }

    public boolean modelledAtSegment() {
        return this.modelledAtSegment;
    }

    public List<Object> singleOrConstantValue() {
        return this.singleOrConstantValue;
    }

    public List<Object> yearToDateValue() {
        return this.yearToDateValue;
    }

    public List<Object> yearToGoValue() {
        return this.yearToGoValue;
    }
}

