/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.securityhelpers;

import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
    @Autowired
    UserDetailsService userDetailsService;

    public AbstractAuthenticationToken convert(@NonNull Jwt jwt) throws ResourceException {
        UserDetails currentUser;
        Collection authorities = (Collection)this.jwtGrantedAuthoritiesConverter.convert((Object)jwt);
        String emailClaimName = "preferred_username";
        String emailClaimValue = jwt.getClaimAsString(emailClaimName);
        try {
            currentUser = this.userDetailsService.loadUserByUsername(emailClaimValue);
        }
        catch (UsernameNotFoundException e) {
            currentUser = null;
        }
        return new UsernamePasswordAuthenticationToken((Object)currentUser, null, authorities);
    }
}

