/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.exceptions.ResourceException;
import app.valuationcontrol.webservice.xlhandler.CalcDocument;
import app.valuationcontrol.webservice.xlhandler.GenericSheet;
import app.valuationcontrol.webservice.xlhandler.POISheet;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * Exception performing whole class analysis ignored.
 */
public class POICalcDocument
implements CalcDocument {
    private static final Logger log = LogManager.getLogger(POICalcDocument.class);
    private static final String SCENARIO_SHEET_PREFIX = "scenario_";
    private final Map<String, GenericSheet> sheetsByName = new ConcurrentHashMap();
    private XSSFWorkbook _notAccessibleWorkbook;

    public POICalcDocument() {
        this.initiateWorkbook();
    }

    private synchronized void initiateWorkbook() {
        this.sheetsByName.clear();
        this._notAccessibleWorkbook = new XSSFWorkbook();
    }

    private synchronized <T> T doOneByOne(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception exception) {
            this.initiateWorkbook();
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private synchronized XSSFWorkbook getWorkbook() {
        return this._notAccessibleWorkbook;
    }

    static String getScenarioSheetName(SCENARIO scenario) throws IllegalArgumentException {
        if (scenario != null) {
            return "scenario_" + scenario.ordinal();
        }
        throw new IllegalArgumentException("Cannot produce sheetname since scenarioNumber = null");
    }

    public void assertConnected(Runnable resetData) {
        this.doOneByOne(() -> {
            try {
                if (this._notAccessibleWorkbook == null) {
                    throw new RuntimeException("Spreadsheet pointer is null");
                }
                XSSFSheet sheet = this.getWorkbook().getSheet(POICalcDocument.getScenarioSheetName((SCENARIO)SCENARIO.BASE));
                log.debug("Found in assertConnected for scenario sheet : " + sheet.getSheetName());
                if (sheet.getPhysicalNumberOfRows() == 0) {
                    throw new RuntimeException("Number of rows is nil so we reload");
                }
            }
            catch (Exception e) {
                log.debug("NOT Found in assertConnected");
                log.debug((Object)e);
                this.initiateWorkbook();
                resetData.run();
            }
            return null;
        });
    }

    public GenericSheet getSheet(SCENARIO scenario) {
        String scenarioSheetName = POICalcDocument.getScenarioSheetName((SCENARIO)scenario);
        return this.sheetsByName.computeIfAbsent(scenarioSheetName, s -> this.copyBaseTo(scenario));
    }

    public void preventScreenUpdating(boolean prevent) {
        log.debug((Object)prevent);
    }

    public void close() {
        this.doOneByOne(() -> {
            if (this._notAccessibleWorkbook == null) {
                log.debug("Workbook was null");
                return null;
            }
            try {
                log.debug("Closing workbook");
                this.getWorkbook().close();
                this._notAccessibleWorkbook = null;
                this.sheetsByName.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public InputStream saveAs() {
        try {
            ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
            this.getWorkbook().write((OutputStream)outputStream1);
            return new ByteArrayInputStream(outputStream1.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(GenericSheet genericSheet) {
        this.doOneByOne(() -> {
            this.sheetsByName.remove(genericSheet.getName());
            this.getWorkbook().getSheetIndex(genericSheet.getName());
            this.getWorkbook().removeSheetAt(this.getWorkbook().getSheetIndex(genericSheet.getName()));
            return null;
        });
    }

    public GenericSheet copy(GenericSheet sourceGenericSheet, String newSheetName) {
        return (GenericSheet)this.doOneByOne(() -> {
            XSSFSheet sourceSheet = this.getWorkbook().getSheet(sourceGenericSheet.getName());
            if (sourceSheet != null) {
                int sourceGenericSheetIndex = this.getWorkbook().getSheetIndex(sourceSheet.getSheetName());
                XSSFSheet _newSheet = this.getWorkbook().cloneSheet(sourceGenericSheetIndex, newSheetName);
                POISheet genericSheet = new POISheet(newSheetName, _newSheet);
                this.sheetsByName.put(newSheetName, genericSheet);
                log.info("Copied sheet successfully to {}", (Object)newSheetName);
                return genericSheet;
            }
            return null;
        });
    }

    private GenericSheet copyBaseTo(SCENARIO scenario) {
        String scenarioSheetName = POICalcDocument.getScenarioSheetName((SCENARIO)scenario);
        return (GenericSheet)this.doOneByOne(() -> {
            block7: {
                if (SCENARIO.BASE.equals((Object)scenario)) {
                    try {
                        if (this.getWorkbook().getSheet(scenarioSheetName) == null) {
                            this.getWorkbook().createSheet(scenarioSheetName);
                            break block7;
                        }
                        this.getWorkbook().removeSheetAt(this.getSheetIndexByName(scenarioSheetName));
                        this.getWorkbook().createSheet(scenarioSheetName);
                    }
                    catch (ResourceException e) {
                        log.error("Wrapped target exception: ", (Throwable)e);
                    }
                } else {
                    try {
                        this.getSheetIndexByName(scenarioSheetName);
                    }
                    catch (IllegalStateException e) {
                        this.getWorkbook().cloneSheet(this.getSheetIndexByName(POICalcDocument.getScenarioSheetName((SCENARIO)SCENARIO.BASE)), scenarioSheetName);
                    }
                }
            }
            XSSFSheet byName = this.getWorkbook().getSheet(scenarioSheetName);
            return new POISheet(scenarioSheetName, byName);
        });
    }

    private int getSheetIndexByName(String sheetName) throws IllegalStateException {
        int sheetIndex = this.getWorkbook().getSheetIndex(sheetName);
        if (sheetIndex == -1) {
            throw new IllegalStateException("Sheet was not found");
        }
        return sheetIndex;
    }

    public void closeAllButBase() {
        this.doOneByOne(() -> {
            Iterator iterator = this.sheetsByName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (POICalcDocument.getScenarioSheetName((SCENARIO)SCENARIO.BASE).equals(next.getKey())) continue;
                iterator.remove();
                this.getWorkbook().removeSheetAt(this.getWorkbook().getSheetIndex(((GenericSheet)next.getValue()).getName()));
            }
            return null;
        });
    }

    public void closeAllSheets() {
        this.doOneByOne(() -> {
            this.initiateWorkbook();
            return null;
        });
    }
}

