/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.CellError;
import app.valuationcontrol.webservice.helpers.DataPeriod;
import app.valuationcontrol.webservice.helpers.StringReplacer;
import app.valuationcontrol.webservice.helpers.VariableReplacementOccurrence;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.xlhandler.CellValueHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariableEvaluator {
    private static final Logger log = LogManager.getLogger(VariableEvaluator.class);
    private static final String CONVERGE_TO_GROUPS = "(convergeto\\()(.+)(\\))";
    public static final String EQUALS = "=";
    private static final String REGEX_STRING_INTERVAL = "t[\\-|\\+]?\\d*";
    private static final String ALL_PERIODS = "allperiods";
    private static final String HISTORICAL_PERIOD = "historicalperiod";
    private static final String PROJECTION_PERIOD = "projectionperiod";
    private static final String LAST_PERIOD = "lastperiod";
    private static final String FIRST_PERIOD = "firstperiod";
    private static final Pattern PATTERN = Pattern.compile("t[\\-|\\+]?\\d*");
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_CURLY = "{";
    private static final String RIGHT_CURLY = "}";
    public static final int AGGREGATION_SEGMENT = -1;
    private static final String[] PREDEFINED_MODIFIERS = new String[]{"allperiods", "projectionperiod", "lastperiod", "firstperiod"};

    private VariableEvaluator() {
    }

    public static String evaluateVariable(Variable variable, DataPeriod dataPeriod, Map<Long, List<CellError>> formulaErrors) {
        String currentEvaluatedFormula = variable.getEvaluatedVariableFormula();
        try {
            Double.parseDouble(currentEvaluatedFormula);
            return VariableEvaluator.asFormula((String)currentEvaluatedFormula);
        }
        catch (Exception exception) {
            if (currentEvaluatedFormula.toLowerCase().matches("(convergeto\\()(.+)(\\))")) {
                currentEvaluatedFormula = VariableEvaluator.makeConvergeFunction((Variable)variable, (DataPeriod)dataPeriod, (String)currentEvaluatedFormula);
            }
            currentEvaluatedFormula = VariableEvaluator.replacePeriodIndicatorsAndPeriodChecks((Variable)variable, (DataPeriod)dataPeriod, (String)currentEvaluatedFormula);
            if (variable.getReplacementOccurrences().isEmpty()) {
                VariableEvaluator.evaluateVariableReplacers((Variable)variable, formulaErrors);
            }
            if (variable.getReplacementOccurrences() == null || variable.getReplacementOccurrences().isEmpty()) {
                return VariableEvaluator.asFormula((String)currentEvaluatedFormula);
            }
            for (VariableReplacementOccurrence variableReplacement : variable.getReplacementOccurrences()) {
                currentEvaluatedFormula = VariableEvaluator.replace((String)currentEvaluatedFormula, (String)VariableEvaluator.getReplacementString((Variable)variable, (DataPeriod)dataPeriod, (VariableReplacementOccurrence)variableReplacement, formulaErrors), (VariableReplacementOccurrence)variableReplacement);
            }
            return VariableEvaluator.asFormula((String)currentEvaluatedFormula);
        }
    }

    private static String replace(String formula, String replacementString, VariableReplacementOccurrence variableReplacement) {
        return formula.replace(variableReplacement.searchString(), replacementString);
    }

    static String asFormula(String currentEvaluatedFormula) {
        return "=" + currentEvaluatedFormula;
    }

    private static String getReplacementString(Variable variable, DataPeriod dataPeriod, VariableReplacementOccurrence variableReplacement, Map<Long, List<CellError>> formulaErrors) {
        String replacementString = variableReplacement.searchString();
        String prefixSearchString = "{" + variableReplacement.searchVariable().getId() + "}";
        String targetReplacementString = replacementString.substring(prefixSearchString.length());
        if (!variableReplacement.searchVariable().isModelledAtSegment()) {
            dataPeriod = new DataPeriod(variable.getAttachedModel(), dataPeriod.periodOffset(), Integer.valueOf(0), variableReplacement.searchVariable().isSingleOrConstantValue());
        }
        for (StringReplacer myReplacer : variableReplacement.stringReplacers()) {
            if (myReplacer.modifier() == null) {
                targetReplacementString = switch (myReplacer.searchString()) {
                    case "allperiods" -> variableReplacement.searchVariable().generateAllPeriodsRange(dataPeriod);
                    case "historicalperiod" -> variableReplacement.searchVariable().generateHistoricalRange(dataPeriod);
                    case "projectionperiod" -> variableReplacement.searchVariable().generateProjectionRange(dataPeriod);
                    case "firstperiod" -> variableReplacement.searchVariable().generateFirstPeriodRange(dataPeriod);
                    case "lastperiod" -> variableReplacement.searchVariable().generateLastPeriodRange(dataPeriod);
                    default -> CellValueHelper.generateAddress((Variable)variableReplacement.searchVariable(), (DataPeriod)dataPeriod);
                };
                continue;
            }
            if (dataPeriod.isWithinBound(Integer.valueOf(dataPeriod.periodOffset() + myReplacer.modifier()))) {
                DataPeriod newDataPeriod = new DataPeriod(variable.getAttachedModel(), Integer.valueOf(myReplacer.modifier() + dataPeriod.periodOffset()), dataPeriod.segmentOffsetFactor(), variableReplacement.searchVariable().isSingleOrConstantValue());
                String addressReplacementString = CellValueHelper.generateAddress((Variable)variableReplacement.searchVariable(), (DataPeriod)newDataPeriod);
                targetReplacementString = targetReplacementString.replace(myReplacer.searchString(), addressReplacementString);
                targetReplacementString = targetReplacementString.replace("[", "").replace("]", "");
                continue;
            }
            targetReplacementString = "-1";
            CellError e = new CellError(dataPeriod.periodOffset(), "OutOfBounds error", "You are trying to access an unsafe area using " + myReplacer.searchString() + " in formula " + variable.getVariableFormula());
            formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
        }
        return targetReplacementString;
    }

    private static String replacePeriodIndicatorsAndPeriodChecks(Variable myVariable, DataPeriod dataPeriod, String currentEvaluatedFormula) {
        currentEvaluatedFormula = currentEvaluatedFormula.replace("periodindicator", Integer.toString(dataPeriod.periodOffset() + 1));
        currentEvaluatedFormula = currentEvaluatedFormula.replace("islastperiod", dataPeriod.periodOffset() + 1 == myVariable.getAttachedModel().getNbProjectionPeriod() ? "1" : "0");
        currentEvaluatedFormula = currentEvaluatedFormula.replace("isfirstperiod", dataPeriod.periodOffset() == 0 ? "1" : "0");
        return currentEvaluatedFormula;
    }

    private static String makeConvergeFunction(Variable variable, DataPeriod dataPeriod, String originalFormula) {
        String target;
        int remainingPeriod = variable.getAttachedModel().getNbProjectionPeriod() - dataPeriod.periodOffset();
        String previousCellAddress = CellValueHelper.generateAddress((Variable)variable, (DataPeriod)dataPeriod.previousPeriod());
        Pattern p = Pattern.compile("(convergeto\\()(.+)(\\))");
        Matcher m = p.matcher(originalFormula);
        if (m.find()) {
            target = m.group(2);
        } else {
            target = originalFormula.replace("convergeto(", "");
            target = target.replace(")", "");
        }
        return "if(isNumber(" + previousCellAddress + ");" + previousCellAddress + "+(" + target + "-" + previousCellAddress + ")/" + remainingPeriod + ";" + target + "/" + remainingPeriod + ")";
    }

    private static void evaluateVariableReplacers(Variable variable, Map<Long, List<CellError>> formulaErrors) {
        Object currentEvaluatedFormula = variable.getEvaluatedVariableFormula();
        for (Variable searchVariable : variable.getVariableDependencies()) {
            ArrayList<StringReplacer> replacers;
            int stringIndex;
            currentEvaluatedFormula = VariableEvaluator.checkForPredefinedModifiers((Variable)variable, (String)currentEvaluatedFormula, (Variable)searchVariable);
            String searchString = "{" + searchVariable.getId() + "}[";
            do {
                if ((stringIndex = ((String)currentEvaluatedFormula).indexOf(searchString)) == -1) continue;
                int stringIndexMiddleStart = stringIndex + searchString.length() - 1;
                Object tempEvaluatedFormula = currentEvaluatedFormula;
                if (!((String)tempEvaluatedFormula).contains("]")) {
                    CellError e = new CellError(Integer.valueOf(-1), "FormulaError", "Couldn't find terminating bracket for formula " + variable.getVariableFormula());
                    formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
                    break;
                }
                replacers = new ArrayList<StringReplacer>();
                int stringIndexStop = ((String)tempEvaluatedFormula).indexOf("]", stringIndex) + 1;
                String startString = ((String)tempEvaluatedFormula).substring(0, stringIndex);
                String middleString = ((String)tempEvaluatedFormula).substring(stringIndexMiddleStart, stringIndexStop);
                String endString = ((String)tempEvaluatedFormula).substring(stringIndexStop);
                Matcher m = PATTERN.matcher(middleString);
                while (m.find()) {
                    String tempModifierString = m.group();
                    int modifier = tempModifierString.equals("t") ? 0 : Integer.parseInt(tempModifierString.replace("t", ""));
                    StringReplacer replacer = new StringReplacer(tempModifierString, Integer.valueOf(modifier));
                    replacers.add(replacer);
                }
                replacers.sort(StringReplacer.StringReplacerComparatorDesc);
                String middleStringBeforeReplacements = middleString;
                for (StringReplacer temp_replacer : replacers) {
                    middleString = middleString.replace(temp_replacer.searchString(), "");
                }
                middleString = middleString.replace("[", "");
                middleString = middleString.replace("]", "");
                currentEvaluatedFormula = startString + middleString + endString;
                VariableReplacementOccurrence vro = new VariableReplacementOccurrence(searchVariable, "{" + searchVariable.getId() + "}".concat(middleStringBeforeReplacements), replacers);
                variable.getReplacementOccurrences().add(vro);
            } while (stringIndex != -1);
            searchString = "{" + searchVariable.getId() + "}";
            do {
                if ((stringIndex = ((String)currentEvaluatedFormula).indexOf(searchString)) == -1) continue;
                replacers = new ArrayList();
                StringReplacer replacer = new StringReplacer(searchString, null);
                replacers.add(replacer);
                VariableReplacementOccurrence vro = new VariableReplacementOccurrence(searchVariable, searchString, replacers);
                variable.getReplacementOccurrences().add(vro);
                currentEvaluatedFormula = ((String)currentEvaluatedFormula).replace(searchString, "");
            } while (stringIndex != -1);
        }
    }

    private static String checkForPredefinedModifiers(Variable variable, String currentEvaluatedFormula, Variable searchVariable) {
        for (String predefinedModifier : PREDEFINED_MODIFIERS) {
            String searchString = "{" + searchVariable.getId() + "}[" + predefinedModifier + "]";
            if (!currentEvaluatedFormula.contains(searchString)) continue;
            StringReplacer replacer = new StringReplacer(predefinedModifier, null);
            VariableReplacementOccurrence vro = new VariableReplacementOccurrence(searchVariable, searchString, Collections.singletonList(replacer));
            variable.getReplacementOccurrences().add(vro);
            currentEvaluatedFormula = currentEvaluatedFormula.replace(searchString, "");
        }
        return currentEvaluatedFormula;
    }
}

