/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.webservice.xlhandler;

import app.valuationcontrol.webservice.helpers.CalculationData;
import app.valuationcontrol.webservice.helpers.CellError;
import app.valuationcontrol.webservice.helpers.DataPeriod;
import app.valuationcontrol.webservice.model.Model;
import app.valuationcontrol.webservice.model.sensitivity.Sensitivity;
import app.valuationcontrol.webservice.model.sensitivity.SensitivityResult;
import app.valuationcontrol.webservice.model.variable.Variable;
import app.valuationcontrol.webservice.model.variablevalue.VariableValue;
import app.valuationcontrol.webservice.xlhandler.CalcDocument;
import app.valuationcontrol.webservice.xlhandler.CellValueHelper;
import app.valuationcontrol.webservice.xlhandler.GenericSheet;
import app.valuationcontrol.webservice.xlhandler.ModelChangeNotifier;
import app.valuationcontrol.webservice.xlhandler.SCENARIO;
import app.valuationcontrol.webservice.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.webservice.xlhandler.SensitivityRunner;
import app.valuationcontrol.webservice.xlhandler.VariableEvaluator;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XLInstance
implements ScenarioDataProvider {
    private static final Logger log = LogManager.getLogger(XLInstance.class);
    public static final String INPUT = "input";
    public static final String PERCENT = "percent";
    public static final int YTD_PERIOD = -500;
    private final CalcDocument calcDocument;
    private final ModelChangeNotifier modelChangeNotifier;
    private Model attachedModel;
    private final Map<Long, List<CellError>> formulaErrors = new ConcurrentHashMap();
    private final Map<SCENARIO, Map<Long, List<CellError>>> variableCellErrorsByScenario = new ConcurrentHashMap();
    private final Map<SCENARIO, Object[][]> cacheValues = new ConcurrentHashMap();
    private List<SensitivityResult> sensitivityResults = new ArrayList();
    private final AtomicLong lastUsed = new AtomicLong();

    public XLInstance(Model attachedModel, CalcDocument calcDocument, ModelChangeNotifier modelChangeNotifier) {
        this.attachedModel = attachedModel;
        this.calcDocument = calcDocument;
        this.modelChangeNotifier = modelChangeNotifier;
        this.lastUsed.set(System.currentTimeMillis());
        this.reloadWholeBaseContentIfNoCache();
    }

    public InputStream saveAs() {
        this.calcDocument.assertConnected(() -> {
            log.debug("saving document");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        return this.calcDocument.saveAs();
    }

    public void reloadAndUpdateClients() {
        log.debug("Entering reloadAndUpdateClients " + String.valueOf(this.calcDocument));
        this.reloadWholeBaseContentIfNoCache();
        this.modelChangeNotifier.getLoadedScenario(this.attachedModel.getId().longValue()).forEach(scenarioNumber -> {
            log.debug("Reload and update clients : Content was reloaded for scenario Base ");
            this.sendUpdateToClients(SCENARIO.from((int)scenarioNumber));
        });
        log.debug("Exiting reloadAndUpdateClients" + String.valueOf(this.calcDocument));
    }

    public void setSingleValue(VariableValue variableValue) {
        if (variableValue != null && variableValue.getValue() != null) {
            this.insertIntoCell(SCENARIO.from((int)variableValue.getScenarioNumber()), CellValueHelper.cellValueOf((VariableValue)variableValue));
        }
    }

    public void runSensitivities(List<Sensitivity> sensitivities, SCENARIO scenario) {
        this.calcDocument.assertConnected(() -> {
            log.debug("CacheValues: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        SensitivityRunner sensitivityRunner = new SensitivityRunner(this.calcDocument, sensitivities, scenario, this.attachedModel);
        this.sensitivityResults = sensitivityRunner.runSensitivities();
    }

    public void updateCacheValues(SCENARIO scenario) {
        if (this.attachedModel.getVariables().isEmpty()) {
            return;
        }
        log.debug("Entering updateCacheValues" + String.valueOf(this.calcDocument));
        try {
            this.lastUsed.set(System.currentTimeMillis());
            long millis = System.currentTimeMillis();
            if (!scenario.equals((Object)SCENARIO.BASE) && this.cacheValues.get(SCENARIO.BASE) == null) {
                this.reloadWholeBaseContentIfNoCache();
            }
            this.calcDocument.assertConnected(() -> {
                log.debug("CacheValues: Force Reloading base");
                this.cacheValues.clear();
                this.reloadWholeBaseContentIfNoCache();
            });
            log.debug("CacheValues: Opening sheet in cacheValues " + String.valueOf(scenario));
            GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(scenario);
            this.setScenarioVariableValues(scenario, scenarioGenericSheet);
            int endRow = this.attachedModel.getNumberOfVariables() - 1;
            Object[][] xlObject = scenarioGenericSheet.getValues(this.attachedModel.indexOfLastColumn(), endRow);
            this.cacheValues.put(scenario, xlObject);
            log.debug("CacheContent for scenario {} was defined in {}", (Object)scenario, (Object)(System.currentTimeMillis() - millis + "ms"));
            log.debug("Exiting updateCacheValues" + String.valueOf(this.calcDocument));
        }
        catch (Exception e) {
            log.error("Couldn't get content " + String.valueOf(e));
        }
    }

    public synchronized CalculationData getContent(SCENARIO scenario) {
        log.debug("Entering getContent" + String.valueOf(this.calcDocument));
        this.lastUsed.set(System.currentTimeMillis());
        long millis = System.currentTimeMillis();
        try {
            if (this.attachedModel.getVariables().isEmpty()) {
                return new CalculationData(this.attachedModel, new ArrayList(), new HashMap(), new HashMap(), scenario.ordinal());
            }
            if (this.cacheValues.get(scenario) == null) {
                log.debug("updating cacheValues in getContent");
                this.updateCacheValues(scenario);
            }
            Object[][] xlObject = (Object[][])this.cacheValues.get(scenario);
            log.debug("CacheValues is of size" + xlObject.length);
            for (Variable variable : this.attachedModel.getVariables()) {
                int row = variable.getRow();
                if (variable.isSingleOrConstantValue()) {
                    ArrayList<Object> singleOrConstantValues = new ArrayList<Object>();
                    singleOrConstantValues.add(xlObject[row][this.attachedModel.getConstantColumn()]);
                    if (variable.isModelledAtSegment()) {
                        for (int i = 1; i <= this.attachedModel.getSegments().size(); ++i) {
                            column = variable.columnOfSegmentAndPeriod(i - 1, Integer.valueOf(0));
                            singleOrConstantValues.add(xlObject[row][column]);
                        }
                    }
                    variable.setSingleOrConstantValue(singleOrConstantValues);
                } else {
                    ArrayList<Object[]> historicalValues = new ArrayList<Object[]>();
                    ArrayList<Object[]> projectionValues = new ArrayList<Object[]>();
                    if (this.attachedModel.isIncludeYTD()) {
                        column = variable.columnOfSegmentAndPeriod(-1, this.attachedModel.getNbProjectionPeriod());
                        variable.getYearToDateValue().add(xlObject[row][column]);
                        variable.getYearToGoValue().add(xlObject[row][column + 1]);
                    }
                    historicalValues.add(Arrays.copyOfRange(xlObject[row], variable.columnOfSegmentAndPeriod(-1, Integer.valueOf(-this.attachedModel.getNbHistoricalPeriod().intValue())), variable.columnOfSegmentAndPeriod(-1, Integer.valueOf(0))));
                    projectionValues.add(Arrays.copyOfRange(xlObject[row], variable.columnOfSegmentAndPeriod(-1, Integer.valueOf(0)), variable.columnOfSegmentAndPeriod(-1, this.attachedModel.getNbProjectionPeriod())));
                    if (variable.isModelledAtSegment()) {
                        for (int i = 0; i < this.attachedModel.getSegments().size(); ++i) {
                            if (this.attachedModel.isIncludeYTD()) {
                                int column = variable.columnOfSegmentAndPeriod(i, this.attachedModel.getNbProjectionPeriod());
                                variable.getYearToDateValue().add(xlObject[row][column]);
                                variable.getYearToGoValue().add(xlObject[row][column + 1]);
                            }
                            int historicalStart = variable.columnOfSegmentAndPeriod(i, Integer.valueOf(-this.attachedModel.getNbHistoricalPeriod().intValue()));
                            int historicalEnd = variable.columnOfSegmentAndPeriod(i, Integer.valueOf(0));
                            historicalValues.add(Arrays.copyOfRange(xlObject[row], historicalStart, historicalEnd));
                            int projectionStart = variable.columnOfSegmentAndPeriod(i, Integer.valueOf(0));
                            int projectionEnd = variable.columnOfSegmentAndPeriod(i, this.attachedModel.getNbProjectionPeriod());
                            projectionValues.add(Arrays.copyOfRange(xlObject[row], projectionStart, projectionEnd));
                        }
                    }
                    variable.setHistoricalValues(historicalValues);
                    variable.setProjectionValues(projectionValues);
                }
                this.getCellErrors(variable, scenario);
            }
            CalculationData returnObject = new CalculationData(this.attachedModel, this.getSensitivityResults(), this.formulaErrors, (Map)this.variableCellErrorsByScenario.get(scenario), scenario.ordinal());
            log.debug("Content for scenario {} was fetched in {}", (Object)scenario, (Object)(System.currentTimeMillis() - millis + "ms"));
            this.lastUsed.set(System.currentTimeMillis());
            log.debug("Exiting getContent" + String.valueOf(this.calcDocument));
            return returnObject;
        }
        catch (Exception e) {
            log.error("Couldn't get content " + String.valueOf(e));
            return null;
        }
    }

    private void setScenarioVariableValues(SCENARIO scenario, GenericSheet scenarioGenericSheet) {
        List cellValues = this.attachedModel.getVariables().stream().flatMap(variable -> variable.getVariableValuesForAScenario(scenario).stream().filter(v -> v.getValue() != null).filter(v -> v.getAttachedVariable().getAttachedModel().isIncludeYTD() || !Objects.requireNonNullElse(v.getPeriod(), 0).equals(-500)).map(CellValueHelper::cellValueOf)).toList();
        if (!cellValues.isEmpty()) {
            scenarioGenericSheet.setCellValues(cellValues.toArray(new GenericSheet.CellValue[0]));
        }
    }

    public String[] generateVariableArray(Variable variable) {
        String[] dumpArrayRow = new String[variable.getAttachedModel().getArraySize().intValue()];
        this.formulaErrors.remove(variable.getId());
        this.initVariableRow(dumpArrayRow, variable);
        boolean segmentExists = this.checkSegmentsExist(variable);
        if (variable.isSingleOrConstantValue()) {
            this.performSingleEntryReplication(variable, dumpArrayRow);
            String summaryFormula = "=";
            if (segmentExists && !variable.getVariableFormat().equals("date")) {
                String divider = variable.getVariableFormat().equals(PERCENT) ? String.valueOf(Math.max(1, this.attachedModel.getSegments().size())) : "1";
                for (int j = 0; j < this.attachedModel.getSegments().size(); ++j) {
                    summaryFormula = MessageFormat.format("{0}+{1}/{2}", summaryFormula, CellValueHelper.generateAddress((Variable)variable, (int)variable.columnOfSegmentAndPeriod(j, Integer.valueOf(1))), divider);
                }
                dumpArrayRow[variable.getPrimaryColumn()] = summaryFormula;
            }
        } else {
            boolean performHistoricalReplication = this.shouldReplicateHistorical(variable);
            if (performHistoricalReplication) {
                this.performHistoricalReplication(variable, dumpArrayRow, segmentExists);
            }
            this.performForecastReplication(variable, dumpArrayRow, segmentExists);
            if (this.attachedModel.isIncludeYTD()) {
                this.performYTDReplication(variable, dumpArrayRow, segmentExists);
            }
            if (segmentExists && !variable.getVariableFormat().equals("date") && !variable.getVariableType().equals(INPUT)) {
                int start = -this.getAttachedModel().getNbHistoricalPeriod().intValue();
                int stop = this.getAttachedModel().getNbProjectionPeriod();
                for (int i = start; i < stop; ++i) {
                    String summaryFormula = "=";
                    if (variable.isPercentOrKPI()) {
                        DataPeriod segmentConstantPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(i), Integer.valueOf(0), variable.isSingleOrConstantValue());
                        summaryFormula = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)segmentConstantPeriod, (Map)this.formulaErrors);
                    } else {
                        for (int j = 0; j < this.attachedModel.getSegments().size(); ++j) {
                            summaryFormula = MessageFormat.format("{0}+{1}", summaryFormula, CellValueHelper.generateAddress((Variable)variable, (int)variable.columnOfSegmentAndPeriod(j, Integer.valueOf(i))));
                        }
                    }
                    dumpArrayRow[variable.getPrimaryColumn() + i] = summaryFormula;
                }
                if (variable.getVariableFormat().equals(PERCENT)) {
                    variable.getVariableDependencies().stream().filter(variable1 -> variable1.getVariableType().equals(INPUT)).forEach(variable2 -> {
                        CellError e = new CellError(Integer.valueOf(0), "Dependency to input", "You should change the formula to avoid the use of input variables (" + variable2.getVariableName() + " ) in an aggregated segment value");
                        this.formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
                    });
                }
            }
        }
        return dumpArrayRow;
    }

    private void performSingleEntryReplication(Variable variable, String[] dumpArrayRow) {
        if (variable.isSingleOrConstantValue()) {
            if (variable.isModelledAtSegment() && this.attachedModel.getSegments() != null && !this.attachedModel.getSegments().isEmpty()) {
                for (int i = 1; i <= this.attachedModel.getSegments().size(); ++i) {
                    DataPeriod segmentConstantPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(0), Integer.valueOf(i), variable.isSingleOrConstantValue());
                    int cellColumn = variable.columnOfSegmentAndPeriod(i - 1, Integer.valueOf(0));
                    dumpArrayRow[cellColumn] = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)segmentConstantPeriod, (Map)this.formulaErrors);
                }
            } else {
                DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(0), Integer.valueOf(0), variable.isSingleOrConstantValue());
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)0))] = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)dataPeriod, (Map)this.formulaErrors);
            }
        }
    }

    private void performYTDReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        int YTDperiod = this.attachedModel.getNbProjectionPeriod();
        int YTGperiod = YTDperiod + 1;
        if (segmentReplicationShouldBePerformed) {
            for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                Object ytgFormula;
                String ytdFormula = null;
                if (variable.isPercentOrKPI() || variable.isTypeTotal()) {
                    DataPeriod YTDdataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(YTDperiod), Integer.valueOf(segmentIndex + 1), variable.isSingleOrConstantValue());
                    DataPeriod YTGdataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(YTGperiod), Integer.valueOf(segmentIndex + 1), variable.isSingleOrConstantValue());
                    ytdFormula = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)YTDdataPeriod, (Map)this.formulaErrors);
                    ytgFormula = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)YTGdataPeriod, (Map)this.formulaErrors);
                } else {
                    ytgFormula = "=" + MessageFormat.format("{0}-{1}", CellValueHelper.generateAddress((Variable)variable, (int)variable.columnOfSegmentAndPeriod(segmentIndex, Integer.valueOf(0))), CellValueHelper.generateAddress((Variable)variable, (int)variable.columnOfSegmentAndPeriod(segmentIndex, Integer.valueOf(YTGperiod - 1))));
                }
                if (ytdFormula != null) {
                    dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)YTDperiod))] = ytdFormula;
                }
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)YTGperiod))] = ytgFormula;
            }
        } else {
            Object ytgFormula;
            String ytdFormula = null;
            if (variable.isPercentOrKPI() || variable.isTypeTotal()) {
                DataPeriod YTDdataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(YTDperiod), Integer.valueOf(0), variable.isSingleOrConstantValue());
                DataPeriod YTGdataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(YTGperiod), Integer.valueOf(0), variable.isSingleOrConstantValue());
                ytdFormula = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)YTDdataPeriod, (Map)this.formulaErrors);
                ytgFormula = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)YTGdataPeriod, (Map)this.formulaErrors);
            } else {
                ytgFormula = "=" + MessageFormat.format("{0}-{1}", CellValueHelper.generateAddress((Variable)variable, (int)variable.columnOfSegmentAndPeriod(-1, Integer.valueOf(0))), CellValueHelper.generateAddress((Variable)variable, (int)variable.columnOfSegmentAndPeriod(-1, Integer.valueOf(YTGperiod - 1))));
            }
            if (ytdFormula != null) {
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)YTDperiod))] = ytdFormula;
            }
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)YTGperiod))] = ytgFormula;
        }
    }

    private void performForecastReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        for (int period = 0; period < this.getAttachedModel().getNbProjectionPeriod(); ++period) {
            if (segmentReplicationShouldBePerformed) {
                for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                    DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(period), Integer.valueOf(segmentIndex + 1), variable.isSingleOrConstantValue());
                    dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)dataPeriod, (Map)this.formulaErrors);
                }
                continue;
            }
            DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(period), Integer.valueOf(0), variable.isSingleOrConstantValue());
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)dataPeriod, (Map)this.formulaErrors);
        }
    }

    private void performHistoricalReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        for (int period = -this.getAttachedModel().getNbHistoricalPeriod().intValue(); period < 0; ++period) {
            if (segmentReplicationShouldBePerformed) {
                for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                    DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(period), Integer.valueOf(segmentIndex + 1), variable.isSingleOrConstantValue());
                    int column = variable.columnOfSegmentAndPeriod(segmentIndex, Integer.valueOf(period));
                    dumpArrayRow[column] = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)dataPeriod, (Map)this.formulaErrors);
                }
                continue;
            }
            DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), Integer.valueOf(period), Integer.valueOf(0), variable.isSingleOrConstantValue());
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable((Variable)variable, (DataPeriod)dataPeriod, (Map)this.formulaErrors);
        }
    }

    private void initVariableRow(String[] dumpArrayRow, Variable variable) {
        dumpArrayRow[0] = String.valueOf(variable.getId());
        dumpArrayRow[1] = variable.getVariableName();
        dumpArrayRow[2] = variable.getVariableFormula();
        dumpArrayRow[3] = variable.getVariableType();
        dumpArrayRow[4] = String.valueOf(variable.getVariableArea().getId());
        dumpArrayRow[5] = String.valueOf(variable.getVariableSubArea().getId());
        dumpArrayRow[6] = variable.getVariableFormat();
        dumpArrayRow[7] = String.valueOf(variable.getVariableOrder());
        dumpArrayRow[8] = String.valueOf(variable.getVariableDepth());
    }

    private boolean shouldReplicateHistorical(Variable myVariable) {
        return this.getAttachedModel().getNbHistoricalPeriod() > 0 && (myVariable.isVariableApplyToHistoricals() || myVariable.getVariableType().contains("total") || myVariable.getVariableType().contains("kpi"));
    }

    private boolean checkSegmentsExist(Variable myVariable) {
        return myVariable.isModelledAtSegment() && !this.attachedModel.getSegments().isEmpty();
    }

    public synchronized void cleanAndUpdateAdditionalSheets() {
        log.debug("Entering cleanAndUpdateAdditionalSheets" + String.valueOf(this.calcDocument));
        this.calcDocument.closeAllButBase();
        this.modelChangeNotifier.getLoadedScenario(this.attachedModel.getId().longValue()).stream().filter(scenarioNumber -> !scenarioNumber.equals(SCENARIO.BASE.ordinal())).forEach(scenarioNumber -> {
            log.debug("Reloading closed sheet for scenario " + scenarioNumber);
            SCENARIO scenario = SCENARIO.from((int)scenarioNumber);
            log.debug("Refreshing scenario " + String.valueOf(scenario));
            this.updateCacheValues(scenario);
        });
        log.debug("Exiting cleanAndUpdateAdditionalSheets" + String.valueOf(this.calcDocument));
    }

    private void sendUpdateToClients(SCENARIO scenario) {
        CalculationData calculationData = this.getContent(scenario);
        this.modelChangeNotifier.updateUsersModel(calculationData);
    }

    private void insertIntoCell(SCENARIO scenario, GenericSheet.CellValue cellValue) {
        GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(scenario);
        scenarioGenericSheet.setCellValues(new GenericSheet.CellValue[]{cellValue});
    }

    public void refreshValue(Variable myVariable, VariableValue myVariableValue) {
        long millis = System.currentTimeMillis();
        this.calcDocument.preventScreenUpdating(true);
        this.calcDocument.assertConnected(() -> {
            log.debug("refreshValue: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        if (Objects.equals(myVariableValue.getScenarioNumber(), SCENARIO.BASE.ordinal())) {
            this.reloadVariableAndUpdateCache(myVariable);
        } else {
            this.cacheValues.remove(SCENARIO.from((int)myVariableValue.getScenarioNumber()));
            this.setSingleValue(myVariableValue);
        }
        this.calcDocument.preventScreenUpdating(false);
        log.debug("Model was refreshed in : " + (System.currentTimeMillis() - millis) + "ms");
    }

    public void reloadVariableAndUpdateCache(Variable variable) {
        log.debug("Entering reloadVariableAndUpdateCache " + String.valueOf(this.calcDocument));
        this.calcDocument.assertConnected(() -> {
            log.debug("reloadVariableAndUpdateCache: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        int arraySize = variable.getAttachedModel().getArraySize();
        String[][] dumpArray = new String[1][arraySize];
        for (int j = 0; j < arraySize; ++j) {
            dumpArray[0][j] = "";
        }
        this.calcDocument.preventScreenUpdating(true);
        dumpArray[0] = this.generateVariableArray(variable);
        GenericSheet baseGenericSheet = this.calcDocument.getSheet(SCENARIO.BASE);
        baseGenericSheet.setRowValues(variable.getRow(), dumpArray[0]);
        this.cacheValues.clear();
        this.updateCacheValues(SCENARIO.BASE);
        this.cleanAndUpdateAdditionalSheets();
        this.calcDocument.preventScreenUpdating(false);
        log.debug("Exiting reloadVariableAndUpdateCache " + String.valueOf(this.calcDocument));
    }

    public void reloadWholeBaseContentIfNoCache() {
        log.debug("Entering reloadWholeBaseContentIfNoCache " + String.valueOf(this.calcDocument));
        if (this.cacheValues.get(SCENARIO.BASE) == null) {
            int numberOfVariables = this.getAttachedModel().getNumberOfVariables();
            long millis = System.currentTimeMillis();
            if (numberOfVariables > 0) {
                int arraySize = this.getAttachedModel().getArraySize();
                String[][] dumpArray = new String[numberOfVariables][arraySize];
                for (int i = 0; i < numberOfVariables; ++i) {
                    for (int j = 0; j < arraySize; ++j) {
                        dumpArray[i][j] = "";
                    }
                }
                this.calcDocument.preventScreenUpdating(true);
                this.calcDocument.closeAllSheets();
                this.formulaErrors.clear();
                long before = System.currentTimeMillis();
                for (Variable myVariable : this.attachedModel.getVariables()) {
                    dumpArray[myVariable.getRow()] = this.generateVariableArray(myVariable);
                }
                log.debug("Logic was loaded in : " + (System.currentTimeMillis() - before) + "ms");
                GenericSheet baseGenericSheet = this.calcDocument.getSheet(SCENARIO.BASE);
                baseGenericSheet.setValue(dumpArray, Math.max(arraySize - 1, 0), Math.max(this.attachedModel.getNumberOfVariables() - 1, 0));
                this.setScenarioVariableValues(SCENARIO.BASE, baseGenericSheet);
                this.updateCacheValues(SCENARIO.BASE);
                this.calcDocument.preventScreenUpdating(false);
                log.debug("Model was refreshed and cached in : " + (System.currentTimeMillis() - millis) + "ms");
            } else {
                log.debug("No variables so model was not reloaded");
            }
        }
    }

    private void getCellErrors(Variable myVariable, SCENARIO scenario) {
        GenericSheet genericSheet = this.calcDocument.getSheet(scenario);
        ArrayList<CellError> cellErrors = new ArrayList<CellError>();
        this.variableCellErrorsByScenario.computeIfAbsent(scenario, i -> new ConcurrentHashMap()).put(myVariable.getId(), cellErrors);
        int historicalPeriods = myVariable.isSingleOrConstantValue() ? 0 : this.attachedModel.getNbHistoricalPeriod();
        int startIndex = myVariable.getPrimaryColumn() - historicalPeriods;
        int periodIndex = -historicalPeriods;
        int i2 = startIndex;
        while (i2 < myVariable.getAttachedModel().getArraySize()) {
            try {
                String error = genericSheet.getErrorInCell(i2, myVariable.getRow());
                if (error != null) {
                    CellError e = new CellError(Integer.valueOf(periodIndex), "CalculationError", error);
                    cellErrors.add(e);
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            ++i2;
            ++periodIndex;
        }
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    public boolean isUnusedFor(Duration inactivityThreshold) {
        return System.currentTimeMillis() - inactivityThreshold.toMillis() > this.lastUsed.get();
    }

    public void sleep() {
        this.calcDocument.close();
    }

    public void clearCacheAndReloadAndUpdateClients() {
        this.cacheValues.clear();
        this.reloadAndUpdateClients();
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public List<SensitivityResult> getSensitivityResults() {
        return this.sensitivityResults;
    }
}

