/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.filters;

import gg.xp.xivapi.filters.SearchFilter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SearchFilters {
    private SearchFilters() {
    }

    public static SearchFilter of(String filterValue) {
        return new SearchFilterImpl(filterValue);
    }

    public static SearchFilter or(String ... filters) {
        return new SearchFilterOr(Stream.of(filters).map(SearchFilters::of).toList());
    }

    public static SearchFilter or(List<SearchFilter> filters) {
        return new SearchFilterOr(new ArrayList<SearchFilter>(filters));
    }

    public static SearchFilter or(SearchFilter ... filters) {
        return new SearchFilterOr(Arrays.asList(filters));
    }

    public static SearchFilter and(String ... filters) {
        return new SearchFilterAnd(Stream.of(filters).map(SearchFilters::of).toList());
    }

    public static SearchFilter and(List<SearchFilter> filters) {
        return new SearchFilterAnd(new ArrayList<SearchFilter>(filters));
    }

    public static SearchFilter and(SearchFilter ... filters) {
        return new SearchFilterAnd(Arrays.asList(filters));
    }

    public static SearchFilter not(SearchFilter filter) {
        return new SearchFilterNot(filter);
    }

    public static SearchFilter binary(String field, String operator, Object value) {
        String string;
        if (value instanceof String) {
            String str = (String)value;
            string = "\"%s\"".formatted(str);
        } else {
            string = value.toString();
        }
        String formattedValue = string;
        return SearchFilters.of("%s%s%s".formatted(field, operator, formattedValue));
    }

    public static SearchFilter eq(String field, Object value) {
        return SearchFilters.binary(field, "=", value);
    }

    public static SearchFilter isTrue(String field) {
        return SearchFilters.binary(field, "=", true);
    }

    public static SearchFilter isFalse(String field) {
        return SearchFilters.binary(field, "=", false);
    }

    public static SearchFilter gte(String field, Number value) {
        return SearchFilters.binary(field, ">=", value);
    }

    public static SearchFilter lte(String field, Number value) {
        return SearchFilters.binary(field, "<=", value);
    }

    public static SearchFilter gt(String field, Number value) {
        return SearchFilters.binary(field, ">", value);
    }

    public static SearchFilter lt(String field, Number value) {
        return SearchFilters.binary(field, "<", value);
    }

    public static SearchFilter strPart(String field, String value) {
        return SearchFilters.binary(field, "~", value);
    }

    public static String any(String field) {
        return field + "[]";
    }

    private record SearchFilterImpl(String filterValue) implements SearchFilter
    {
        @Override
        public String toFilterString() {
            return this.filterValue;
        }

        @Override
        public String toString() {
            return this.filterValue;
        }
    }

    private record SearchFilterOr(List<SearchFilter> filters) implements SearchFilter
    {
        @Override
        public String toFilterString() {
            if (this.filters.size() == 1) {
                return this.filters.get(0).toFilterString();
            }
            return this.filters.stream().flatMap(child -> {
                if (child instanceof SearchFilterOr) {
                    SearchFilterOr orChild = (SearchFilterOr)child;
                    return orChild.filters().stream();
                }
                return Stream.of(child);
            }).map(searchFilter -> {
                String inner = searchFilter.toFilterStringWrapped();
                if (inner.startsWith("-")) {
                    return "(" + inner + ")";
                }
                return inner;
            }).collect(Collectors.joining(" "));
        }

        @Override
        public String toFilterStringWrapped() {
            return "(" + this.toFilterString() + ")";
        }

        @Override
        public String toString() {
            return this.filters.stream().map((Function<SearchFilter, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lgg/xp/xivapi/filters/SearchFilter;)Ljava/lang/String;)()).collect(Collectors.joining(" ", "Or(", ")"));
        }
    }

    private record SearchFilterAnd(List<SearchFilter> filters) implements SearchFilter
    {
        @Override
        public String toFilterString() {
            if (this.filters.size() == 1) {
                return this.filters.get(0).toFilterString();
            }
            return this.filters.stream().flatMap(child -> {
                if (child instanceof SearchFilterAnd) {
                    SearchFilterAnd andChild = (SearchFilterAnd)child;
                    return andChild.filters().stream();
                }
                return Stream.of(child);
            }).map(searchFilter -> {
                if (searchFilter instanceof SearchFilterNot) {
                    SearchFilterNot notChild = (SearchFilterNot)searchFilter;
                    return notChild.toFilterString();
                }
                return searchFilter.toFilterStringWrapped();
            }).map(s -> {
                if (s.startsWith("-")) {
                    return s;
                }
                return "+" + s;
            }).collect(Collectors.joining(" "));
        }

        @Override
        public String toString() {
            return this.filters.stream().map((Function<SearchFilter, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lgg/xp/xivapi/filters/SearchFilter;)Ljava/lang/String;)()).collect(Collectors.joining(" ", "And(", ")"));
        }
    }

    private record SearchFilterNot(SearchFilter filter) implements SearchFilter
    {
        @Override
        public String toFilterString() {
            SearchFilter searchFilter = this.filter;
            if (searchFilter instanceof SearchFilterNot) {
                SearchFilterNot notChild = (SearchFilterNot)searchFilter;
                return notChild.filter.toFilterString();
            }
            String inner = this.filter.toFilterString();
            if (inner.startsWith("-") || inner.startsWith("+")) {
                return "-(" + inner + ")";
            }
            return "-" + inner;
        }

        @Override
        public String toString() {
            return "Not(%s)".formatted(this.filter);
        }
    }
}

