/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.annotations.OmitZeroes;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.AutoValueMapper;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFieldMapper<X>
implements FieldMapper<List<X>> {
    private static final Logger log = LoggerFactory.getLogger(ListFieldMapper.class);
    private final AutoValueMapper<X> innerMapper;
    private final boolean omitZero;

    public ListFieldMapper(Class<List<X>> cls, Method method, Type returnTypeFull, ObjectMapper mapper) {
        Class<?> listTypeAsCls;
        Type listType;
        if (!cls.equals(List.class)) {
            throw new IllegalArgumentException("Type must be a List<X>, not %s".formatted(cls));
        }
        if (returnTypeFull instanceof ParameterizedType) {
            AnnotatedParameterizedType apt;
            AnnotatedType annotatedType;
            ParameterizedType actualType = (ParameterizedType)returnTypeFull;
            listType = actualType.getActualTypeArguments()[0];
            listTypeAsCls = MappingUtils.parameterizedTypeToRawClass(listType);
            boolean bl = this.omitZero = method.isAnnotationPresent(OmitZeroes.class) || (annotatedType = method.getAnnotatedReturnType()) instanceof AnnotatedParameterizedType && (apt = (AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()[0].isAnnotationPresent(OmitZeroes.class);
            if (this.omitZero && !XivApiObject.class.isAssignableFrom(listTypeAsCls)) {
                throw new IllegalArgumentException("@OmitZeroes only makes sense when dealing with a sheet object type");
            }
        } else {
            throw new RuntimeException("Unexpected type %s for method %s - not a generic list type".formatted(returnTypeFull, returnTypeFull));
        }
        this.innerMapper = new AutoValueMapper(listTypeAsCls, method, listType, mapper);
    }

    @Override
    public List<X> getValue(JsonNode current, XivApiContext context) {
        if (!current.isArray()) {
            throw new IllegalArgumentException("Expected an array, got %s".formatted(current));
        }
        ArrayList<X> out = new ArrayList<X>(current.size());
        for (JsonNode jsonNode : current) {
            X value = this.innerMapper.getValue(jsonNode, context);
            if (this.omitZero && ((XivApiObject)value).isZero()) continue;
            out.add(value);
        }
        return Collections.unmodifiableList(out);
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
        parent.markAsArray();
        this.innerMapper.buildQueryFields(parent);
    }
}

