/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.getters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import gg.xp.xivapi.exceptions.XivApiMissingNodeException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.AutoValueMapper;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.lang.reflect.Method;

public class TransientFieldMapper<X>
implements FieldMapper<X> {
    private final String fieldName;
    private final Class<X> fieldType;
    private final FieldMapper<X> innerMapper;
    private final Method method;

    public TransientFieldMapper(String fieldName, Class<X> fieldType, Method method, ObjectMapper mapper) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.method = method;
        this.innerMapper = new AutoValueMapper<X>(fieldType, method, method.getGenericReturnType(), mapper);
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        if (current == null) {
            throw new XivApiMissingNodeException("'current' is null", null, this.fieldType, this.method);
        }
        JsonNode transientFieldsNode = current.get("transient");
        if (transientFieldsNode == null) {
            throw new XivApiMissingNodeException("'transient' node is missing", current, this.fieldType, this.method);
        }
        JsonNode fieldNode = transientFieldsNode.get(this.fieldName);
        if (fieldNode == null) {
            throw new XivApiMissingNodeException("Missing transient field node for field " + this.fieldName, transientFieldsNode, this.fieldType, this.method);
        }
        try {
            return this.innerMapper.getValue(fieldNode, context);
        }
        catch (Throwable t) {
            throw new XivApiDeserializationException("Error deserializing %s from %s".formatted(this.fieldName, current), t);
        }
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
        QueryFieldsBuilder child = QueryFieldsBuilder.normalField(this.fieldName);
        boolean isArray = MappingUtils.isArrayQueryType(this.fieldType);
        if (isArray) {
            child.markAsArray();
        }
        child.markAsTransient();
        this.innerMapper.buildQueryFields(child);
        parent.addChild(child);
    }
}

