/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.annotations.NullIfZero;
import gg.xp.xivapi.annotations.XivApiAs;
import gg.xp.xivapi.annotations.XivApiLang;
import gg.xp.xivapi.annotations.XivApiMetaField;
import gg.xp.xivapi.annotations.XivApiRaw;
import gg.xp.xivapi.annotations.XivApiThis;
import gg.xp.xivapi.annotations.XivApiTransientField;
import gg.xp.xivapi.clienttypes.XivApiBase;
import gg.xp.xivapi.clienttypes.XivApiLangValue;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.collections.KeyedAlikeMap;
import gg.xp.xivapi.collections.KeyedAlikeMapFactory;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import gg.xp.xivapi.mappers.getters.MetaFieldMapper;
import gg.xp.xivapi.mappers.getters.NormalFieldMapper;
import gg.xp.xivapi.mappers.getters.ThisFieldMapper;
import gg.xp.xivapi.mappers.getters.TransientFieldMapper;
import gg.xp.xivapi.mappers.objects.LangValueFieldMapper;
import gg.xp.xivapi.mappers.objects.ObjectInvocationHandler;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFieldMapper<X>
implements FieldMapper<X> {
    private static final Logger log = LoggerFactory.getLogger(ObjectFieldMapper.class);
    private final Map<Method, FieldMapper<?>> methodFieldMap = new LinkedHashMap();
    private final Class<X> objectType;
    private final Method pkMethod;
    private final Method ridMethod;
    private final Method svMethod;
    private final Method tsMethod;
    private final KeyedAlikeMapFactory<Method> kaMapFactory;

    public ObjectFieldMapper(Class<X> cls, ObjectMapper mapper) {
        this.objectType = cls;
        try {
            this.pkMethod = cls.getMethod("getPrimaryKey", new Class[0]);
            this.ridMethod = cls.getMethod("getRowId", new Class[0]);
            this.svMethod = XivApiBase.class.getMethod("getSchemaVersion", new Class[0]);
            this.tsMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new XivApiException(e);
        }
        for (Method method : cls.getMethods()) {
            FieldMapper<Object> fieldMapper;
            if (method.getDeclaringClass().isAssignableFrom(XivApiObject.class) || method.isDefault()) continue;
            Class<?> returnType = method.getReturnType();
            XivApiThis thisAnn = method.getAnnotation(XivApiThis.class);
            XivApiMetaField metaFieldAnn = method.getAnnotation(XivApiMetaField.class);
            XivApiTransientField transientFieldAnn = method.getAnnotation(XivApiTransientField.class);
            Object fieldName = MappingUtils.getFieldName(method);
            if (thisAnn != null) {
                fieldMapper = new ThisFieldMapper(transientFieldAnn != null, returnType, method, mapper);
            } else if (metaFieldAnn != null) {
                fieldMapper = new MetaFieldMapper((String)fieldName, returnType, method, mapper);
            } else if (returnType.equals(XivApiLangValue.class)) {
                fieldMapper = new LangValueFieldMapper((String)fieldName, transientFieldAnn != null, method, mapper);
            } else {
                XivApiAs genericAs;
                XivApiLang langAnn = method.getAnnotation(XivApiLang.class);
                if (method.isAnnotationPresent(XivApiRaw.class)) {
                    fieldName = (String)fieldName + "@as(raw)";
                }
                if ((genericAs = method.getAnnotation(XivApiAs.class)) != null) {
                    fieldName = (String)fieldName + "@as(%s)".formatted(genericAs.value());
                }
                if (langAnn != null) {
                    fieldName = (String)fieldName + "@lang(%s)".formatted(langAnn.value());
                }
                fieldMapper = transientFieldAnn != null ? new TransientFieldMapper((String)fieldName, returnType, method, mapper) : new NormalFieldMapper((String)fieldName, returnType, method, mapper);
            }
            this.methodFieldMap.put(method, fieldMapper);
        }
        HashSet<Method> allMethods = new HashSet<Method>(this.methodFieldMap.keySet());
        allMethods.add(this.pkMethod);
        allMethods.add(this.ridMethod);
        allMethods.add(this.svMethod);
        allMethods.add(this.tsMethod);
        this.kaMapFactory = new KeyedAlikeMapFactory<Method>(allMethods);
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        KeyedAlikeMap<Method, Object> methodValueMap = this.kaMapFactory.create();
        try {
            int rowId;
            int primaryKey;
            boolean isNested;
            boolean bl = isNested = current != context.rootNode();
            if (isNested) {
                boolean zeroValue;
                boolean bl2 = zeroValue = current.get("value").asInt() == 0;
                if (zeroValue && (current.get("row_id") == null || current.get("fields") == null || current.get("fields").isEmpty())) {
                    return null;
                }
                if (zeroValue && this.objectType.isAnnotationPresent(NullIfZero.class)) {
                    return null;
                }
                primaryKey = current.get("value").asInt();
                rowId = current.get("row_id").asInt();
            } else {
                rowId = primaryKey = current.get("row_id").asInt();
            }
            methodValueMap.put(this.pkMethod, primaryKey);
            methodValueMap.put(this.ridMethod, rowId);
            methodValueMap.put(this.svMethod, context.schemaVersion());
            methodValueMap.put(this.tsMethod, "%s(%s)".formatted(this.objectType.getSimpleName(), rowId));
            this.methodFieldMap.forEach((method, fieldMapper) -> {
                Object value = fieldMapper.getValue(current, context);
                methodValueMap.put((Method)method, value);
            });
        }
        catch (Throwable t) {
            throw new XivApiDeserializationException("Error deserializing %s from '%s'".formatted(this.objectType, current), t);
        }
        boolean strict = context.settings().isStrict();
        return (X)context.cache().computeIfAbsent(this.objectType, methodValueMap, map -> Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.objectType}, (InvocationHandler)new ObjectInvocationHandler((Map<Method, Object>)map, strict)));
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
        for (FieldMapper<?> mapper : this.methodFieldMap.values()) {
            mapper.buildQueryFields(parent);
        }
    }
}

