/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gg.xp.xivapi.annotations.XivApiAs;
import gg.xp.xivapi.annotations.XivApiRaw;
import gg.xp.xivapi.clienttypes.XivApiLangValue;
import gg.xp.xivapi.exceptions.XivApiMappingException;
import gg.xp.xivapi.exceptions.XivApiMissingNodeException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.AutoValueMapper;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LangValueFieldMapper<X>
implements FieldMapper<XivApiLangValue<X>> {
    private final Method method;
    private final String fieldName;
    private final boolean isTransient;
    private final Pattern fieldMatcher;
    private final List<String> langs;
    private final AutoValueMapper<X> innerMapper;
    private final Class<X> innerTypeClass;

    public LangValueFieldMapper(String fieldName, boolean isTransient, Method method, ObjectMapper mapper) {
        XivApiAs genericAs;
        if (method.isAnnotationPresent(XivApiRaw.class)) {
            fieldName = (String)fieldName + "@as(raw)";
        }
        if ((genericAs = method.getAnnotation(XivApiAs.class)) != null) {
            fieldName = (String)fieldName + "@as(%s)".formatted(genericAs.value());
        }
        this.fieldName = fieldName;
        this.isTransient = isTransient;
        this.method = method;
        this.fieldMatcher = Pattern.compile(Pattern.quote((String)fieldName) + "@lang\\(([a-z]+)\\)");
        this.langs = MappingUtils.ALL_LANGS;
        ParameterizedType fullType = (ParameterizedType)method.getGenericReturnType();
        Type innerType = fullType.getActualTypeArguments()[0];
        this.innerTypeClass = MappingUtils.parameterizedTypeToRawClass(innerType);
        this.innerMapper = new AutoValueMapper<X>(this.innerTypeClass, method, innerType, mapper);
    }

    @Override
    public XivApiLangValue<X> getValue(JsonNode current, XivApiContext context) {
        if (current == null) {
            throw new XivApiMissingNodeException("'current' is null", null, (Type)((Object)XivApiLangValue.class), this.method);
        }
        String fieldName = this.isTransient ? "transient" : "fields";
        JsonNode fieldsNode = current.get(fieldName);
        if (fieldsNode == null) {
            throw new XivApiMissingNodeException("'%s' node is missing".formatted(fieldName), current, (Type)((Object)XivApiLangValue.class), this.method);
        }
        HashMap out = new HashMap(4);
        fieldsNode.fields().forEachRemaining(entry -> {
            Matcher matcher = this.fieldMatcher.matcher((CharSequence)entry.getKey());
            if (matcher.matches()) {
                String lang = matcher.group(1).intern();
                X value = this.innerMapper.getValue((JsonNode)entry.getValue(), context);
                out.put(lang, value);
            }
        });
        if (out.isEmpty()) {
            throw new XivApiMappingException("There were no matching language nodes for field %s".formatted(this.fieldName));
        }
        return new LangValueImpl(Collections.unmodifiableMap(out));
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
        boolean isArray = MappingUtils.isArrayQueryType(this.innerTypeClass);
        for (String lang : this.langs) {
            QueryFieldsBuilder child = QueryFieldsBuilder.normalField(this.fieldName);
            if (isArray) {
                child.markAsArray();
            }
            if (this.isTransient) {
                child.markAsTransient();
            }
            child.addDecorator("lang(%s)".formatted(lang));
            this.innerMapper.buildQueryFields(child);
            parent.addChild(child);
        }
    }

    @JsonSerialize(using=LangValueSerializer.class)
    private record LangValueImpl<X>(@JsonIgnore Map<String, X> values) implements XivApiLangValue<X>
    {
        @Override
        public Map<String, X> getAll() {
            return this.values;
        }
    }

    public static class LangValueSerializer
    extends JsonSerializer<XivApiLangValue<?>> {
        public void serialize(XivApiLangValue<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject(value.getAll());
        }
    }
}

