/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.clienttypes.XivApiSchemaVersion;
import gg.xp.xivapi.clienttypes.XivApiSettings;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.exceptions.XivApiMappingException;
import gg.xp.xivapi.filters.SearchFilter;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.QueryField;
import gg.xp.xivapi.mappers.objects.ObjectFieldMapper;
import gg.xp.xivapi.mappers.util.MappingUtils;
import gg.xp.xivapi.pagination.ListOptions;
import gg.xp.xivapi.pagination.XivApiListPaginator;
import gg.xp.xivapi.pagination.XivApiPaginator;
import gg.xp.xivapi.pagination.XivApiSearchPaginator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XivApiClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(XivApiClient.class);
    private static final ExecutorService exs = Executors.newCachedThreadPool();
    private final ObjectMapper mapper = new ObjectMapper();
    private final XivApiSettings settings;
    private final HttpClient client;
    @Nullable
    private final Semaphore limiter;
    private ListOptions<XivApiObject> defaultListOpts = ListOptions.newBuilder().build();
    private final Map<Class<? extends XivApiObject>, Future<ObjectFieldMapper<? extends XivApiObject>>> mappingCache = new ConcurrentHashMap<Class<? extends XivApiObject>, Future<ObjectFieldMapper<? extends XivApiObject>>>();

    public XivApiClient(XivApiSettings settings) {
        this.settings = settings;
        this.client = HttpClient.newBuilder().build();
        int limit = settings.getConcurrencyLimit();
        this.limiter = limit > 0 ? new Semaphore(limit) : null;
    }

    public XivApiClient(Consumer<XivApiSettings.Builder> configurer) {
        this(XivApiSettings.newBuilder().configure(configurer).build());
    }

    public XivApiClient() {
        this(XivApiSettings.newBuilder().build());
    }

    public XivApiSettings getSettings() {
        return this.settings;
    }

    public URI getBaseUri() {
        return this.settings.getBaseUri();
    }

    public JsonNode sendGET(URI uri) {
        JsonNode root;
        log.info("GET URI: {}", (Object)uri);
        HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
        try {
            if (this.limiter != null) {
                this.limiter.acquire();
            }
            String response = this.client.send(request, HttpResponse.BodyHandlers.ofString()).body();
            root = this.mapper.readTree(response);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.limiter != null) {
                this.limiter.release();
            }
        }
        return root;
    }

    private <X extends XivApiObject> ObjectFieldMapper<X> getMapping(Class<X> cls) {
        Future existing = this.mappingCache.computeIfAbsent(cls, clazz -> exs.submit(() -> new ObjectFieldMapper(cls, this.mapper)));
        try {
            return (ObjectFieldMapper)existing.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new XivApiMappingException("Failed to construct mapping for %s".formatted(cls), e.getCause());
        }
    }

    private List<NameValuePair> getDefaultParams() {
        ArrayList<NameValuePair> out = new ArrayList<NameValuePair>();
        if (this.settings.getGameVersion() != null) {
            out.add((NameValuePair)new BasicNameValuePair("version", this.settings.getGameVersion()));
        }
        if (this.settings.getSchemaVersion() != null) {
            out.add((NameValuePair)new BasicNameValuePair("schema", this.settings.getSchemaVersion()));
        }
        return out;
    }

    public URIBuilder buildUri() {
        return new URIBuilder(this.getBaseUri()).addParameters(this.getDefaultParams());
    }

    public URI buildUri(Consumer<URIBuilder> func) {
        URIBuilder builder = this.buildUri();
        func.accept(builder);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new XivApiException("Error constructing URI", e);
        }
    }

    public <X extends XivApiObject> X getById(Class<X> cls, int id) {
        String sheetName = MappingUtils.validateAndGetSheetName(cls);
        ObjectFieldMapper<X> mapping = this.getMapping(cls);
        List<QueryField> fields = mapping.getQueryFields();
        URI uri = this.buildUri(builder -> builder.appendPath("sheet").appendPath(sheetName).appendPath(String.valueOf(id)).addParameters(MappingUtils.formatQueryFields(fields)));
        JsonNode root = this.sendGET(uri);
        XivApiSchemaVersion sv = MappingUtils.makeSchemaVersion(root.get("schema").textValue());
        XivApiContext context = new XivApiContext(root, this.settings, sv);
        return (X)((XivApiObject)mapping.getValue(root, context));
    }

    private ListOptions<XivApiObject> defaultListOptions() {
        return this.defaultListOpts;
    }

    public void setDefaultListOpts(ListOptions<XivApiObject> defaultListOpts) {
        this.defaultListOpts = defaultListOpts;
    }

    public <X extends XivApiObject> XivApiPaginator<X> getListIterator(Class<X> cls) {
        return this.getListIterator(cls, this.defaultListOptions());
    }

    public <X extends XivApiObject> XivApiPaginator<X> getListIterator(Class<X> cls, ListOptions<? super X> options) {
        String sheetName = MappingUtils.validateAndGetSheetName(cls);
        ObjectFieldMapper<X> mapping = this.getMapping(cls);
        List<QueryField> fields = mapping.getQueryFields();
        int perPage = options.getPerPage();
        URI firstPageUri = this.buildUri(builder -> builder.appendPath("sheet").appendPath(sheetName).addParameters(MappingUtils.formatQueryFields(fields)).setParameter("limit", String.valueOf(perPage)));
        JsonNode firstPage = this.sendGET(firstPageUri);
        return new XivApiListPaginator<XivApiObject>(this, firstPage, firstPageUri, options::shouldStop, mapping, 100);
    }

    public <X extends XivApiObject> XivApiPaginator<X> getSearchIterator(Class<X> cls, SearchFilter filter) {
        return this.getSearchIterator(cls, filter, this.defaultListOptions());
    }

    public <X extends XivApiObject> XivApiPaginator<X> getSearchIterator(Class<X> cls, SearchFilter filter, ListOptions<? super X> options) {
        String sheetName = MappingUtils.validateAndGetSheetName(cls);
        ObjectFieldMapper<X> mapping = this.getMapping(cls);
        List<QueryField> fields = mapping.getQueryFields();
        int perPage = options.getPerPage();
        URI firstPageUri = this.buildUri(builder -> builder.appendPath("search").setParameter("sheets", sheetName).setParameter("query", filter.toFilterString()).setParameter("limit", String.valueOf(perPage)).addParameters(MappingUtils.formatQueryFields(fields)));
        JsonNode firstPage = this.sendGET(firstPageUri);
        return new XivApiSearchPaginator<XivApiObject>(this, firstPage, firstPageUri, options::shouldStop, mapping, 100);
    }

    public List<String> getGameVersions() {
        URI uri = this.buildUri(builder -> builder.appendPath("version"));
        JsonNode result = this.sendGET(uri);
        return (List)this.mapper.convertValue((Object)result, (TypeReference)new TypeReference<List<String>>(this){});
    }

    @Override
    public void close() {
        this.client.close();
        this.mappingCache.clear();
    }
}

