/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.getters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import gg.xp.xivapi.exceptions.XivApiMissingNodeException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.AutoValueMapper;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryField;
import java.lang.reflect.Method;
import java.util.List;

public class ThisFieldMapper<X>
implements FieldMapper<X> {
    private final Class<X> fieldType;
    private final FieldMapper<X> innerMapper;
    private final Method method;
    private final boolean isTransient;

    public ThisFieldMapper(boolean isTransient, Class<X> fieldType, Method method, ObjectMapper mapper) {
        this.isTransient = isTransient;
        this.fieldType = fieldType;
        this.method = method;
        this.innerMapper = new AutoValueMapper<X>(fieldType, method, method.getGenericReturnType(), mapper);
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        if (current == null) {
            throw new XivApiMissingNodeException("'current' is null", null, this.fieldType, this.method);
        }
        String fieldName = this.isTransient ? "transient" : "fields";
        JsonNode fieldsNode = current.get(fieldName);
        if (fieldsNode == null) {
            throw new XivApiMissingNodeException("'%s' node is missing".formatted(fieldName), current, this.fieldType, this.method);
        }
        try {
            return this.innerMapper.getValue(fieldsNode, context);
        }
        catch (Throwable t) {
            throw new XivApiDeserializationException("Error deserializing %s from %s".formatted(this.method.getName(), current), t);
        }
    }

    @Override
    public List<QueryField> getQueryFields() {
        return List.of(this.isTransient ? QueryField.transientField(QueryField.ALL) : QueryField.normalField(QueryField.ALL));
    }
}

