/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.annotations.OmitZeroes;
import gg.xp.xivapi.annotations.XivApiMapKeys;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.AutoValueMapper;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryField;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFieldMapper<X>
implements FieldMapper<Map<String, X>> {
    private static final Logger log = LoggerFactory.getLogger(MapFieldMapper.class);
    private final AutoValueMapper<X> innerMapper;
    private final Class<X> valueType;
    private final boolean omitZero;
    private final Predicate<String> includeKey;

    public MapFieldMapper(Class<Map<String, X>> cls, Method method, Type returnTypeFull, ObjectMapper mapper) {
        if (!cls.equals(Map.class)) {
            throw new IllegalArgumentException("Type must be an array, not %s".formatted(cls));
        }
        Type valueTypeFull = ((ParameterizedType)returnTypeFull).getActualTypeArguments()[1];
        this.valueType = MappingUtils.parameterizedTypeToRawClass(valueTypeFull);
        this.omitZero = method.isAnnotationPresent(OmitZeroes.class);
        if (this.omitZero && !XivApiObject.class.isAssignableFrom(this.valueType)) {
            throw new IllegalArgumentException("@OmitZeroes only makes sense when dealing with a sheet object type");
        }
        this.innerMapper = new AutoValueMapper<X>(this.valueType, method, valueTypeFull, mapper);
        XivApiMapKeys mapKeysAnn = method.getAnnotation(XivApiMapKeys.class);
        this.includeKey = mapKeysAnn != null ? Pattern.compile(mapKeysAnn.value()).asMatchPredicate() : s -> true;
    }

    @Override
    public Map<String, X> getValue(JsonNode current, XivApiContext context) {
        if (!current.isObject()) {
            throw new IllegalArgumentException("Expected a json object, got %s".formatted(current));
        }
        HashMap out = new HashMap();
        current.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            if (this.includeKey.test(key)) {
                XivApiObject obj;
                X value = this.innerMapper.getValue((JsonNode)entry.getValue(), context);
                if (this.omitZero && value instanceof XivApiObject && (obj = (XivApiObject)value).isZero()) {
                    return;
                }
                out.put(key, value);
            }
        });
        return out;
    }

    @Override
    public List<QueryField> getQueryFields() {
        return this.innerMapper.getQueryFields();
    }
}

