/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.clienttypes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class XivApiSettings {
    private final boolean strict;
    private final URI baseUri;
    private final int concurrencyLimit;
    @Nullable
    private final String gameVersion;
    @Nullable
    private final String schemaVersion;

    private XivApiSettings(boolean strict, URI baseUri, int concurrencyLimit, @Nullable String gameVersion, @Nullable String schemaVersion) {
        this.strict = strict;
        this.baseUri = baseUri;
        this.concurrencyLimit = concurrencyLimit;
        this.gameVersion = gameVersion;
        this.schemaVersion = schemaVersion;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public int getConcurrencyLimit() {
        return this.concurrencyLimit;
    }

    @Nullable
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Nullable
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        boolean strict = true;
        URI baseUri;
        int concurrencyLimit = 10;
        @Nullable
        String gameVersion;
        @Nullable
        String schemaVersion;

        public Builder() {
            try {
                this.baseUri = new URI("https://beta.xivapi.com/api/1");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder setConcurrencyLimit(int concurrencyLimit) {
            this.concurrencyLimit = concurrencyLimit;
            return this;
        }

        public Builder setGameVersion(@Nullable String gameVersion) {
            this.gameVersion = gameVersion;
            return this;
        }

        public Builder setSchemaVersion(@Nullable String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public XivApiSettings build() {
            return new XivApiSettings(this.strict, this.baseUri, this.concurrencyLimit, this.gameVersion, this.schemaVersion);
        }

        public Builder configure(Consumer<Builder> configurer) {
            configurer.accept(this);
            return this;
        }
    }
}

