/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.debug;

import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.clienttypes.XivApiStruct;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;

public final class DebugUtils {
    private DebugUtils() {
    }

    public static Map<Method, Object> extractMethodValueMap(XivApiObject object) {
        return DebugUtils.extractMethodValueMapInt(object);
    }

    public static Map<Method, Object> extractMethodValueMap(XivApiStruct object) {
        return DebugUtils.extractMethodValueMapInt(object);
    }

    private static Map<Method, Object> extractMethodValueMapInt(Object object) {
        if (object instanceof Proxy) {
            Proxy proxy = (Proxy)object;
            try {
                Field handlerField = Proxy.class.getDeclaredField("h");
                handlerField.setAccessible(true);
                InvocationHandler handler = (InvocationHandler)handlerField.get(proxy);
                Field[] handlerFields = handler.getClass().getDeclaredFields();
                Field mapField = Arrays.stream(handlerFields).filter(field -> field.getType().equals(Map.class)).findFirst().orElseThrow(() -> new RuntimeException("foo"));
                mapField.setAccessible(true);
                return (Map)mapField.get(handler);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Not a proxy: " + String.valueOf(object));
    }
}

