/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers;

import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.mappers.RootQueryFieldsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public sealed class QueryFieldsBuilder
permits RootQueryFieldsBuilder {
    protected final String name;
    protected boolean isTransient;
    protected boolean isArray;
    protected final List<String> decorators;
    protected final List<QueryFieldsBuilder> children;
    protected static final String ALL = "*";
    protected static final String ROOT = "$ROOT$";

    protected QueryFieldsBuilder(String name) {
        this(name, false, false, List.of(), List.of());
    }

    protected QueryFieldsBuilder(String name, boolean isTransient, boolean isArray, List<String> decorators, List<QueryFieldsBuilder> children) {
        this.name = name;
        this.isTransient = isTransient;
        this.isArray = isArray;
        this.decorators = new ArrayList<String>(decorators);
        this.children = new ArrayList<QueryFieldsBuilder>(children);
    }

    public static QueryFieldsBuilder all() {
        return new QueryFieldsBuilder(ALL);
    }

    public static QueryFieldsBuilder normalField(String name) {
        return new QueryFieldsBuilder(name, false, false, new ArrayList<String>(), new ArrayList<QueryFieldsBuilder>());
    }

    public void markAsTransient() {
        this.isTransient = true;
    }

    public void markAsArray() {
        this.isArray = true;
    }

    public void addDecorator(String decorator) {
        this.decorators.add(decorator);
    }

    public void addChild(QueryFieldsBuilder child) {
        this.children.add(child);
    }

    public boolean isAll() {
        return ALL.equals(this.name);
    }

    public String toString() {
        return "QueryField(%s)".formatted(this.toQueryStrings(false));
    }

    public List<String> toQueryStrings(boolean isTopLevel) {
        if (this.children.isEmpty() && this.isAll()) {
            if (isTopLevel) {
                return List.of(ALL);
            }
            return List.of();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        this.decorators.forEach(deco -> sb.append('@').append((String)deco));
        if (this.isArray) {
            sb.append("[]");
        }
        String value = sb.toString();
        Set out = this.children.stream().flatMap(child -> {
            if (child.isTransient && !isTopLevel) {
                throw new XivApiException("Cannot have a transient field '%s' in a nested object".formatted(child.name));
            }
            if (child.isAll()) {
                return Stream.of(value);
            }
            return child.toQueryStrings(false).stream().map(childQs -> value + "." + childQs);
        }).collect(Collectors.toSet());
        if (out.isEmpty()) {
            return List.of(value);
        }
        return new ArrayList<String>(out);
    }
}

