/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.clienttypes.XivApiBase;
import gg.xp.xivapi.clienttypes.XivApiStruct;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import gg.xp.xivapi.mappers.getters.FlatFieldMapper;
import gg.xp.xivapi.mappers.objects.StructInvocationHandler;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructFieldMapper<X>
implements FieldMapper<X> {
    private static final Logger log = LoggerFactory.getLogger(StructFieldMapper.class);
    private final Map<Method, FieldMapper<?>> methodFieldMap = new LinkedHashMap();
    private final Class<X> objectType;
    private final Method svMethod;
    private final Method tsMethod;

    public StructFieldMapper(Class<X> cls, ObjectMapper mapper) {
        this.objectType = cls;
        try {
            this.svMethod = XivApiBase.class.getMethod("getSchemaVersion", new Class[0]);
            this.tsMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new XivApiException(e);
        }
        for (Method method : cls.getMethods()) {
            if (method.getDeclaringClass().isAssignableFrom(XivApiStruct.class) || method.isDefault()) continue;
            Class<?> returnType = method.getReturnType();
            String fieldName = MappingUtils.getFieldName(method);
            FlatFieldMapper fieldMapper = new FlatFieldMapper(fieldName, returnType, method, mapper);
            this.methodFieldMap.put(method, fieldMapper);
        }
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        LinkedHashMap<Method, Object> methodValueMap = new LinkedHashMap<Method, Object>();
        methodValueMap.put(this.svMethod, context.schemaVersion());
        methodValueMap.put(this.tsMethod, "%s(StructProxy)".formatted(this.objectType.getSimpleName()));
        this.methodFieldMap.forEach((method, fieldMapper) -> {
            Object value = fieldMapper.getValue(current, context);
            methodValueMap.put((Method)method, value);
        });
        return (X)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.objectType}, (InvocationHandler)new StructInvocationHandler(methodValueMap, context.settings().isStrict()));
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
    }
}

