/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.util;

import gg.xp.xivapi.annotations.XivApiField;
import gg.xp.xivapi.annotations.XivApiMetaField;
import gg.xp.xivapi.annotations.XivApiSheet;
import gg.xp.xivapi.annotations.XivApiTransientField;
import gg.xp.xivapi.clienttypes.XivApiSchemaVersion;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MappingUtils {
    public static final List<String> ALL_LANGS = List.of("en", "de", "fr", "ja");

    private MappingUtils() {
    }

    public static String getFieldName(Method method) {
        String fieldName;
        XivApiField fieldAnnotation = method.getAnnotation(XivApiField.class);
        if (fieldAnnotation != null) {
            return fieldAnnotation.value();
        }
        XivApiMetaField metaFieldAnn = method.getAnnotation(XivApiMetaField.class);
        if (metaFieldAnn != null) {
            return metaFieldAnn.value();
        }
        XivApiTransientField transAnn = method.getAnnotation(XivApiTransientField.class);
        if (transAnn != null && !transAnn.value().isEmpty()) {
            return transAnn.value();
        }
        if (method.getName().startsWith("get")) {
            fieldName = method.getName().substring(3);
        } else if (method.getName().startsWith("is")) {
            fieldName = method.getName().substring(2);
        } else {
            throw new RuntimeException("I don't know how to map " + method.getName());
        }
        return fieldName;
    }

    public static boolean isArrayQueryType(Class<?> type) {
        return type.equals(List.class) || type.isArray();
    }

    public static String validateAndGetSheetName(Class<?> cls) {
        if (!cls.isInterface()) {
            throw new IllegalArgumentException("Argument must be an interface, got %s".formatted(cls));
        }
        XivApiSheet sheetAnn = cls.getAnnotation(XivApiSheet.class);
        if (sheetAnn == null || sheetAnn.value().isEmpty()) {
            return cls.getSimpleName();
        }
        return sheetAnn.value();
    }

    public static Class<?> parameterizedTypeToRawClass(Type typeOriginal) {
        Type type = typeOriginal;
        while (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            type = pt.getRawType();
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls;
        }
        throw new IllegalArgumentException("Cannot determine base type for " + String.valueOf(typeOriginal));
    }

    public static XivApiSchemaVersion makeSchemaVersion(String version) {
        return new XivApiSchemaImpl(version);
    }

    public static boolean methodMapEquals(Map<Method, Object> left, Map<Method, Object> right) {
        if (!Objects.equals(left.keySet(), right.keySet())) {
            return false;
        }
        for (Map.Entry<Method, Object> entry : left.entrySet()) {
            Object rightValue;
            Object leftValue = entry.getValue();
            if (MappingUtils.unknownValueEquals(leftValue, rightValue = right.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static boolean unknownValueEquals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass().isArray() && right.getClass().isArray()) {
            return Arrays.equals((Object[])left, (Object[])right);
        }
        return Objects.equals(left, right);
    }

    private record XivApiSchemaImpl(String version) implements XivApiSchemaVersion
    {
        @Override
        public String fullVersionString() {
            return this.version;
        }
    }
}

