/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import gg.xp.xivapi.annotations.NullIfZero;
import gg.xp.xivapi.clienttypes.XivApiBase;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.clienttypes.XivApiStruct;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructInvocationHandler
implements InvocationHandler,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(StructInvocationHandler.class);
    private static final long serialVersionUID = -7240936731264081326L;
    private static final Method equalsMethod;
    private static final Method hashCodeMethod;
    private static final Method mapMethod;
    private final Map<Method, Object> methodValueMap;
    private final boolean strict;

    public StructInvocationHandler(Map<Method, Object> methodValueMap, boolean strict) {
        this.methodValueMap = methodValueMap;
        this.strict = strict;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        XivApiObject xao;
        Object value = this.methodValueMap.get(method);
        if (value == null) {
            Class<?> returnType;
            if (method.isDefault()) {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            if (method.equals(mapMethod)) {
                return Collections.unmodifiableMap(this.methodValueMap);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                if (method.equals(hashCodeMethod)) {
                    return MappingUtils.methodMapHashCode(this.methodValueMap);
                }
                if (method.equals(equalsMethod)) {
                    Object that = args[0];
                    if (that == proxy) {
                        return true;
                    }
                    if (that instanceof XivApiStruct) {
                        XivApiStruct other = (XivApiStruct)that;
                        Map<Method, Object> otherValueMap = other.getMethodValueMap();
                        return MappingUtils.methodMapEquals(this.methodValueMap, otherValueMap);
                    }
                    return false;
                }
            }
            if ((returnType = method.getReturnType()).isPrimitive()) {
                if (this.strict) {
                    throw new XivApiDeserializationException("Null primitive field! %s".formatted(method));
                }
                log.error("Null primitive field! {}", (Object)method.getName());
                if (returnType.equals(Boolean.TYPE)) {
                    return false;
                }
                return 0;
            }
            if (!method.isAnnotationPresent(NullIfZero.class) && !returnType.isAnnotationPresent(NullIfZero.class)) {
                if (this.strict) {
                    throw new XivApiDeserializationException("Null object field! %s".formatted(method));
                }
                log.error("Null object field! {}", (Object)method.getName());
            }
        }
        if (value instanceof XivApiObject && (xao = (XivApiObject)value).getPrimaryKey() == 0 && method.isAnnotationPresent(NullIfZero.class)) {
            return null;
        }
        return value;
    }

    private Object writeReplace() throws ObjectStreamException {
        HashMap<MethodMetadata, Object> metaMap = new HashMap<MethodMetadata, Object>(this.methodValueMap.size());
        for (Map.Entry<Method, Object> entry : this.methodValueMap.entrySet()) {
            metaMap.put(MethodMetadata.fromMethod(entry.getKey()), entry.getValue());
        }
        return new SerializableForm(metaMap, this.strict);
    }

    static {
        try {
            equalsMethod = Object.class.getMethod("equals", Object.class);
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            mapMethod = XivApiBase.class.getMethod("getMethodValueMap", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MethodMetadata
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String methodName;
        private final String[] parameterTypeNames;
        private final String interfaceClassName;

        public MethodMetadata(String methodName, String[] parameterTypeNames, String interfaceClassName) {
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
            this.interfaceClassName = interfaceClassName;
        }

        public static MethodMetadata fromMethod(Method method) {
            return new MethodMetadata(method.getName(), (String[])Arrays.stream(method.getParameterTypes()).map(Class::getName).toArray(String[]::new), method.getDeclaringClass().getName());
        }

        public Method toMethod() throws NoSuchMethodException, ClassNotFoundException {
            Class<?> interfaceClass = Class.forName(this.interfaceClassName);
            Class[] parameterTypes = (Class[])Arrays.stream(this.parameterTypeNames).map(name -> {
                try {
                    return Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(Class[]::new);
            return interfaceClass.getMethod(this.methodName, parameterTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodMetadata that = (MethodMetadata)obj;
            return this.methodName.equals(that.methodName) && Arrays.equals(this.parameterTypeNames, that.parameterTypeNames) && this.interfaceClassName.equals(that.interfaceClassName);
        }

        public int hashCode() {
            int result = Objects.hash(this.methodName, this.interfaceClassName);
            result = 31 * result + Arrays.hashCode(this.parameterTypeNames);
            return result;
        }
    }

    private record SerializableForm(Map<MethodMetadata, Object> methodMetaMap, boolean strict) implements Serializable
    {
        private Object readResolve() {
            HashMap<Method, Object> methodMap = new HashMap<Method, Object>(this.methodMetaMap.size());
            for (Map.Entry<MethodMetadata, Object> entry : this.methodMetaMap.entrySet()) {
                try {
                    methodMap.put(entry.getKey().toMethod(), entry.getValue());
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
            return new StructInvocationHandler(methodMap, this.strict);
        }
    }
}

