/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.impl;

import gg.xp.xivapi.assets.AssetFormat;
import gg.xp.xivapi.clienttypes.XivApiSettings;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.url.XivApiUrlResolver;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public final class UrlResolverImpl
implements XivApiUrlResolver,
Serializable {
    private static final long serialVersionUID = -1458487307014327401L;
    private final URI baseUri;
    private final URI baseAssetUri;
    private final List<NameValuePair> defaultParams;

    public UrlResolverImpl(XivApiSettings settings) {
        this.baseUri = settings.getBaseUri();
        this.baseAssetUri = settings.getBaseAssetUri();
        this.defaultParams = UrlResolverImpl.makeDefaultParams(settings);
    }

    private static List<NameValuePair> makeDefaultParams(XivApiSettings settings) {
        ArrayList<NameValuePair> out = new ArrayList<NameValuePair>();
        if (settings.getGameVersion() != null) {
            out.add((NameValuePair)new BasicNameValuePair("version", settings.getGameVersion()));
        }
        if (settings.getSchemaVersion() != null) {
            out.add((NameValuePair)new BasicNameValuePair("schema", settings.getSchemaVersion()));
        }
        return out;
    }

    @Override
    public URIBuilder buildUri() {
        return new URIBuilder(this.baseUri).addParameters(this.defaultParams);
    }

    @Override
    public URI buildUri(Consumer<URIBuilder> func) {
        URIBuilder builder = this.buildUri();
        func.accept(builder);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new XivApiException("Error constructing URI", e);
        }
    }

    @Override
    public URI getAssetUri(String assetPath, AssetFormat format) {
        return this.getAssetUri(assetPath, format.getAssetFormatParam());
    }

    @Override
    public URI getAssetUri(String assetPath, String format) {
        try {
            return new URIBuilder(this.baseAssetUri).appendPath("/asset").appendPath(assetPath).addParameter("format", format).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof UrlResolverImpl)) return false;
        UrlResolverImpl other = (UrlResolverImpl)obj;
        if (!Objects.equals(this.baseAssetUri, other.baseAssetUri)) return false;
        if (!Objects.equals(this.baseUri, other.baseUri)) return false;
        if (!Objects.equals(this.defaultParams, other.defaultParams)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.baseUri, this.baseAssetUri, this.defaultParams);
    }
}

