/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.annotations.OmitZeroes;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.AutoValueMapper;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryFieldsBuilder;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayFieldMapper<X>
implements FieldMapper<X[]> {
    private static final Logger log = LoggerFactory.getLogger(ArrayFieldMapper.class);
    private final AutoValueMapper<X> innerMapper;
    private final Class<X> componentType;
    private final boolean omitZero;

    public ArrayFieldMapper(Class<X[]> cls, Method method, Type returnTypeFull, ObjectMapper mapper) {
        if (!cls.isArray()) {
            throw new IllegalArgumentException("Type must be an array, not %s".formatted(cls));
        }
        TypeDescriptor.OfField listTypeAsCls = cls.componentType();
        this.componentType = listTypeAsCls;
        this.omitZero = method.isAnnotationPresent(OmitZeroes.class);
        if (this.omitZero && !XivApiObject.class.isAssignableFrom((Class<?>)listTypeAsCls)) {
            throw new IllegalArgumentException("@OmitZeroes only makes sense when dealing with a sheet object type");
        }
        this.innerMapper = new AutoValueMapper(listTypeAsCls, method, (Type)((Object)listTypeAsCls), mapper);
    }

    @Override
    public X[] getValue(JsonNode current, XivApiContext context) {
        if (!current.isArray()) {
            throw new IllegalArgumentException("Expected an array, got %s".formatted(current));
        }
        ArrayList<X> out = new ArrayList<X>(current.size());
        for (JsonNode jsonNode : current) {
            X value = this.innerMapper.getValue(jsonNode, context);
            if (this.omitZero && ((XivApiObject)value).isZero()) continue;
            out.add(value);
        }
        Object[] array = (Object[])Array.newInstance(this.componentType, out.size());
        for (int i = 0; i < out.size(); ++i) {
            array[i] = out.get(i);
        }
        return array;
    }

    @Override
    public void buildQueryFields(QueryFieldsBuilder parent) {
        parent.markAsArray();
        this.innerMapper.buildQueryFields(parent);
    }
}

