/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.assets.AssetFormat;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.clienttypes.XivApiSchemaVersion;
import gg.xp.xivapi.clienttypes.XivApiSettings;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.exceptions.XivApiMappingException;
import gg.xp.xivapi.filters.SearchFilter;
import gg.xp.xivapi.impl.DedupeCacheImpl;
import gg.xp.xivapi.impl.UrlResolverImpl;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.objects.ObjectFieldMapper;
import gg.xp.xivapi.mappers.objects.RootMapper;
import gg.xp.xivapi.mappers.util.MappingUtils;
import gg.xp.xivapi.mappers.util.ThreadingUtils;
import gg.xp.xivapi.pagination.ListOptions;
import gg.xp.xivapi.pagination.XivApiListPaginator;
import gg.xp.xivapi.pagination.XivApiPaginator;
import gg.xp.xivapi.pagination.XivApiSearchPaginator;
import gg.xp.xivapi.url.XivApiUrlResolver;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.apache.hc.core5.net.URIBuilder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XivApiClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(XivApiClient.class);
    private static final ExecutorService exs = Executors.newCachedThreadPool(ThreadingUtils.namedDaemonThreadFactory("XivApiClient"));
    private final ObjectMapper mapper = new ObjectMapper();
    private final XivApiSettings settings;
    private final HttpClient client;
    @Nullable
    private final Semaphore limiter;
    private final UrlResolverImpl urlResolver;
    private ListOptions<XivApiObject> defaultListOpts = ListOptions.newBuilder().build();
    private final Map<Class<? extends XivApiObject>, Future<RootMapper<? extends XivApiObject>>> rootMappingCache = new ConcurrentHashMap<Class<? extends XivApiObject>, Future<RootMapper<? extends XivApiObject>>>();

    public XivApiClient(XivApiSettings settings) {
        this.settings = settings;
        this.client = HttpClient.newBuilder().build();
        int limit = settings.getConcurrencyLimit();
        this.limiter = limit > 0 ? new Semaphore(limit) : null;
        this.urlResolver = new UrlResolverImpl(settings);
    }

    public XivApiClient(Consumer<XivApiSettings.Builder> configurer) {
        this(XivApiSettings.newBuilder().configure(configurer).build());
    }

    public XivApiClient() {
        this(XivApiSettings.newBuilder().build());
    }

    public XivApiSettings getSettings() {
        return this.settings;
    }

    public URI getBaseUri() {
        return this.settings.getBaseUri();
    }

    public JsonNode sendGET(URI uri) {
        JsonNode root;
        log.info("GET URI: {}", (Object)uri);
        HttpRequest request = HttpRequest.newBuilder(uri).GET().header("User-Agent", this.settings.getUserAgent()).build();
        try {
            String response;
            if (this.limiter != null) {
                this.limiter.acquire();
            }
            if ((root = this.mapper.readTree(response = this.client.send(request, HttpResponse.BodyHandlers.ofString()).body())).has("code") && root.has("message")) {
                throw new XivApiException("Xivapi returned error. Code %s, message '%s'".formatted(root.get("code"), root.get("message").textValue()));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.limiter != null) {
                this.limiter.release();
            }
        }
        return root;
    }

    private <X extends XivApiObject> RootMapper<X> getMapping(Class<X> cls) {
        Future existing = this.rootMappingCache.computeIfAbsent(cls, clazz -> exs.submit(() -> new RootMapper(new ObjectFieldMapper(cls, this.mapper))));
        try {
            return (RootMapper)existing.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new XivApiMappingException("Failed to construct mapping for %s".formatted(cls), e.getCause());
        }
    }

    public URIBuilder buildUri() {
        return this.urlResolver.buildUri();
    }

    public URI buildUri(Consumer<URIBuilder> func) {
        return this.urlResolver.buildUri(func);
    }

    public <X extends XivApiObject> X getById(Class<X> cls, int id) {
        String sheetName = MappingUtils.validateAndGetSheetName(cls);
        RootMapper mapping = this.getMapping(cls);
        URI uri = this.buildUri(builder -> builder.appendPath("sheet").appendPath(sheetName).appendPath(String.valueOf(id)).addParameters(mapping.getQueryFields()));
        JsonNode root = this.sendGET(uri);
        XivApiSchemaVersion sv = MappingUtils.makeSchemaVersion(root.get("schema").textValue());
        DedupeCacheImpl cache = new DedupeCacheImpl();
        XivApiContext context = new XivApiContext(root, this.settings, sv, this.urlResolver, cache);
        return (X)((XivApiObject)mapping.getWrappedMapper().getValue(root, context));
    }

    private ListOptions<XivApiObject> defaultListOptions() {
        return this.defaultListOpts;
    }

    public void setDefaultListOpts(ListOptions<XivApiObject> defaultListOpts) {
        this.defaultListOpts = defaultListOpts;
    }

    public <X extends XivApiObject> XivApiPaginator<X> getListIterator(Class<X> cls) {
        return this.getListIterator(cls, this.defaultListOptions());
    }

    public <X extends XivApiObject> XivApiPaginator<X> getListIterator(Class<X> cls, ListOptions<? super X> options) {
        String sheetName = MappingUtils.validateAndGetSheetName(cls);
        RootMapper mapping = this.getMapping(cls);
        int perPage = options.getPerPage();
        URI firstPageUri = this.buildUri(builder -> builder.appendPath("sheet").appendPath(sheetName).addParameters(mapping.getQueryFields()).setParameter("limit", String.valueOf(perPage)));
        JsonNode firstPage = this.sendGET(firstPageUri);
        return new XivApiListPaginator<XivApiObject>(this, firstPage, firstPageUri, options::shouldStop, mapping.getWrappedMapper(), 100, options.getListCacheMode());
    }

    public <X extends XivApiObject> XivApiPaginator<X> getSearchIterator(Class<X> cls, SearchFilter filter) {
        return this.getSearchIterator(cls, filter, this.defaultListOptions());
    }

    public <X extends XivApiObject> XivApiPaginator<X> getSearchIterator(Class<X> cls, SearchFilter filter, ListOptions<? super X> options) {
        String sheetName = MappingUtils.validateAndGetSheetName(cls);
        RootMapper mapping = this.getMapping(cls);
        int perPage = options.getPerPage();
        URI firstPageUri = this.buildUri(builder -> builder.appendPath("search").setParameter("sheets", sheetName).setParameter("query", filter.toFilterString()).setParameter("limit", String.valueOf(perPage)).addParameters(mapping.getQueryFields()));
        JsonNode firstPage = this.sendGET(firstPageUri);
        return new XivApiSearchPaginator<XivApiObject>(this, firstPage, firstPageUri, options::shouldStop, mapping.getWrappedMapper(), 100, options.getListCacheMode());
    }

    public List<String> getGameVersions() {
        URI uri = this.buildUri(builder -> builder.appendPath("version"));
        JsonNode result = this.sendGET(uri);
        return (List)this.mapper.convertValue((Object)result, (TypeReference)new TypeReference<List<String>>(){});
    }

    public URI getAssetUri(String assetPath, AssetFormat format) {
        return this.urlResolver.getAssetUri(assetPath, format);
    }

    public URI getAssetUri(String assetPath, String format) {
        return this.urlResolver.getAssetUri(assetPath, format);
    }

    public <X extends XivApiObject> void validateModel(Class<X> clazz) {
        this.getMapping(clazz);
    }

    public XivApiUrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    @Override
    public void close() {
        this.client.close();
        this.rootMappingCache.clear();
    }
}

