/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.clienttypes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class XivApiSettings {
    private final boolean strict;
    private final URI baseUri;
    @Nullable
    private final URI baseAssetUri;
    private final int concurrencyLimit;
    @Nullable
    private final String gameVersion;
    @Nullable
    private final String schemaVersion;
    private final String userAgent;

    private XivApiSettings(boolean strict, URI baseUri, @Nullable URI baseAssetUri, int concurrencyLimit, @Nullable String gameVersion, @Nullable String schemaVersion, String userAgent) {
        this.strict = strict;
        this.baseUri = baseUri;
        this.baseAssetUri = baseAssetUri;
        this.concurrencyLimit = concurrencyLimit;
        this.gameVersion = gameVersion;
        this.schemaVersion = schemaVersion;
        this.userAgent = userAgent;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public URI getBaseAssetUri() {
        return this.baseAssetUri == null ? this.baseUri : this.baseAssetUri;
    }

    public int getConcurrencyLimit() {
        return this.concurrencyLimit;
    }

    @Nullable
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Nullable
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        boolean strict = true;
        URI baseUri;
        @Nullable
        URI baseAssetUri;
        int concurrencyLimit = 10;
        @Nullable
        String gameVersion;
        @Nullable
        String schemaVersion;
        String userAgent = "Xivapi-Java";

        public Builder() {
            try {
                this.baseUri = new URI("https://beta.xivapi.com/api/1");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder setStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder setBaseAssetUri(@Nullable URI baseAssetUri) {
            this.baseAssetUri = baseAssetUri;
            return this;
        }

        public Builder setConcurrencyLimit(int concurrencyLimit) {
            this.concurrencyLimit = concurrencyLimit;
            return this;
        }

        public Builder setGameVersion(@Nullable String gameVersion) {
            this.gameVersion = gameVersion;
            return this;
        }

        public Builder setSchemaVersion(@Nullable String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder configure(Consumer<Builder> configurer) {
            configurer.accept(this);
            return this;
        }

        public XivApiSettings build() {
            return new XivApiSettings(this.strict, this.baseUri, this.baseAssetUri, this.concurrencyLimit, this.gameVersion, this.schemaVersion, this.userAgent);
        }
    }
}

