/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedAlikeMap<K, V>
implements Map<K, V> {
    private final Map<K, Integer> keyMapping;
    private final Object[] valueMapping;
    private static final Object NULL_MARKER = new Object();

    KeyedAlikeMap(Map<K, Integer> keyMapping) {
        this.keyMapping = keyMapping;
        this.valueMapping = new Object[keyMapping.size()];
    }

    @Override
    public int size() {
        int sz = 0;
        for (Object o : this.valueMapping) {
            if (o == null) continue;
            ++sz;
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        for (Object o : this.valueMapping) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        Integer index = this.keyMapping.get(key);
        return this.valueMapping[index] != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object o : this.valueMapping) {
            if (!(value == null ? o == NULL_MARKER : Objects.equals(o, value))) continue;
            return true;
        }
        return false;
    }

    private int indexForStrict(Object key) {
        int index = this.indexForLax(key);
        if (index < 0) {
            throw new IllegalArgumentException("Key not present in allowed key set: " + String.valueOf(key));
        }
        return index;
    }

    private int indexForLax(Object key) {
        Integer index = this.keyMapping.get(key);
        if (index == null) {
            return -1;
        }
        if (index < 0 || index >= this.valueMapping.length) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        return index;
    }

    @Override
    @Nullable
    public V get(Object key) {
        int index = this.indexForLax(key);
        if (index < 0) {
            return null;
        }
        Object value = this.valueMapping[index];
        if (value == NULL_MARKER) {
            return null;
        }
        return (V)value;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        int index = this.indexForStrict(key);
        Object oldValue = this.valueMapping[index];
        this.valueMapping[index] = value == null ? NULL_MARKER : value;
        return (V)(oldValue == NULL_MARKER ? null : oldValue);
    }

    @Override
    public V remove(Object key) {
        int index = this.indexForLax(key);
        if (index < 0) {
            return null;
        }
        Object oldValue = this.valueMapping[index];
        this.valueMapping[index] = null;
        return (V)(oldValue == NULL_MARKER ? null : oldValue);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        Arrays.fill(this.valueMapping, null);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return KeyedAlikeMap.this.keyMapping.keySet().stream().filter(key -> {
                    int index = KeyedAlikeMap.this.indexForStrict(key);
                    Object valueRaw = KeyedAlikeMap.this.valueMapping[index];
                    return valueRaw != null;
                }).iterator();
            }

            @Override
            public int size() {
                return KeyedAlikeMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return KeyedAlikeMap.this.containsKey(o);
            }
        };
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return Arrays.stream(KeyedAlikeMap.this.valueMapping).flatMap(valueRaw -> {
                    if (valueRaw == null) {
                        return Stream.empty();
                    }
                    if (valueRaw == NULL_MARKER) {
                        return Stream.of(null);
                    }
                    return Stream.of(valueRaw);
                }).iterator();
            }

            @Override
            public int size() {
                return KeyedAlikeMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return KeyedAlikeMap.this.containsValue(o);
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return KeyedAlikeMap.this.keyMapping.keySet().stream().map(key -> {
                    int index = KeyedAlikeMap.this.indexForStrict(key);
                    Object valueRaw = KeyedAlikeMap.this.valueMapping[index];
                    if (valueRaw == null) {
                        return null;
                    }
                    if (valueRaw == NULL_MARKER) {
                        valueRaw = null;
                    }
                    Object finalValueRaw = valueRaw;
                    return new EntryImpl<Object, Object>(key, finalValueRaw);
                }).filter(Objects::nonNull).iterator();
            }

            @Override
            public int size() {
                return KeyedAlikeMap.this.size();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            h += entry.hashCode();
        }
        return h;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "KeyedAlikeMap{}";
        }
        StringBuilder sb = new StringBuilder("KeyedAlikeMap{");
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private record EntryImpl<K, V>(K key, V value) implements Map.Entry<K, V>
    {
        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(Object value) {
            throw new UnsupportedOperationException("Cannot set values via entrySet()");
        }
    }
}

