/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.pagination;

import gg.xp.xivapi.exceptions.XivApiPaginationException;
import gg.xp.xivapi.mappers.util.ThreadingUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedIterator<X>
implements Iterator<X> {
    private static final Logger log = LoggerFactory.getLogger(BufferedIterator.class);
    private final Queue<X> buffer = new ArrayDeque<X>();
    private final Object lock = new Object();
    private volatile boolean done;
    @Nullable
    private volatile Throwable failure;

    public BufferedIterator(Iterator<X> iter, int bufferSize) {
        WeakReference thisRef = new WeakReference(this);
        BufferedIterator.startFeedLoop(thisRef, this.lock, bufferSize, this.buffer, iter);
    }

    private static <Y> void startFeedLoop(WeakReference<BufferedIterator<Y>> thisRef, Object lock, int bufferSize, Queue<Y> buffer, Iterator<Y> iter) {
        ThreadingUtils.tryStartVirtualThread(() -> {
            try {
                while (iter.hasNext()) {
                    if (thisRef.get() == null) {
                        return;
                    }
                    Object next = iter.next();
                    Object object = lock;
                    synchronized (object) {
                        while (buffer.size() >= bufferSize) {
                            if (thisRef.get() == null) {
                                return;
                            }
                            try {
                                lock.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        buffer.add(next);
                        lock.notifyAll();
                    }
                }
                return;
            }
            catch (Throwable t) {
                log.error("BufferedIterator failed to read from {}", (Object)iter, (Object)t);
                BufferedIterator thisResolved = (BufferedIterator)thisRef.get();
                if (thisResolved == null) return;
                thisResolved.failure = t;
                return;
            }
            finally {
                BufferedIterator thisResolved = (BufferedIterator)thisRef.get();
                if (thisResolved != null) {
                    thisResolved.done();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            X next;
            while ((next = this.buffer.peek()) == null) {
                if (this.done) {
                    if (this.failure == null) return false;
                    return true;
                }
                try {
                    this.lock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X next() {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                X next;
                if ((next = this.buffer.poll()) != null) {
                    this.lock.notifyAll();
                    return next;
                }
                if (this.done) {
                    if (this.failure != null) {
                        throw new XivApiPaginationException("BufferedIterator failed to read", this.failure);
                    }
                    throw new NoSuchElementException("Iteration done");
                }
                try {
                    this.lock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

