/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code;

import as.leap.code.LogDelegate;
import as.leap.code.LogDelegateFactory;
import as.leap.code.Logger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LoggerFactory {
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    private static synchronized void initialise() {
        LogDelegateFactory delegateFactory;
        Class<?> clz;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            clz = loader.loadClass("as.leap.code.impl.Log4j2DelegateFactory");
        }
        catch (ClassNotFoundException e) {
            try {
                clz = loader.loadClass("as.leap.code.impl.JULLoggerDelegateFactory");
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalArgumentException("can not load Log class", e1);
            }
        }
        try {
            delegateFactory = (LogDelegateFactory)clz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating transformer Log class", e);
        }
        LoggerFactory.delegateFactory = delegateFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger = (Logger)loggers.get(name);
        if (logger == null && (oldLogger = loggers.putIfAbsent(name, logger = new Logger(delegate = delegateFactory.createDelegate(name)))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
    }
}

