/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code;

import as.leap.code.LASException;
import as.leap.code.impl.GlobalConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CloudCodeContants {
    public static final String HEADER_ZCLOUD_APPID = "X-ZCloud-AppId";
    public static final String HEADER_ZCLOUD_MASTERKEY = "X-ZCloud-MasterKey";
    public static final String HEADER_ZCLOUD_REQUEST_FROM_CLOUDCODE = "X-ZCloud-Request-From-Cloudcode";
    public static String DEFAULT_API_ADDRESS_PREFIX = "http://apiuat.zcloud.io/2.0";
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 15000;
    public static GlobalConfig GLOBAL_CONFIG;
    public static Properties LEAP_CONFIG;
    public static Map<String, String> HEADERS;

    public static void init() throws LASException {
        GLOBAL_CONFIG = CloudCodeContants.loadGlobalConfig();
        LEAP_CONFIG = CloudCodeContants.loadLeapConfig();
        DEFAULT_API_ADDRESS_PREFIX = LEAP_CONFIG.getProperty("url.leap", "http://apiuat.zcloud.io/2.0");
        CloudCodeContants.initHeader();
    }

    private static GlobalConfig loadGlobalConfig() {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/global.json");
        if (inputStream == null) {
            throw new LASException("you must have a global.json config file for your cloud code.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            StringBuilder globalBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                globalBuilder.append(line).append("\n");
            }
            return new GlobalConfig(globalBuilder.toString());
        }
        catch (LASException e) {
            throw new LASException("Your global.json config is not match json format.Please check your config. Caused by " + e.getMessage());
        }
        catch (IOException e) {
            throw new LASException(e);
        }
    }

    private static Properties loadLeapConfig() {
        Properties properties = new Properties();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("leap-config.properties");
        if (inputStream == null) {
            return properties;
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static void initHeader() {
        HEADERS.put(HEADER_ZCLOUD_APPID, GLOBAL_CONFIG.getApplicationID());
        HEADERS.put(HEADER_ZCLOUD_MASTERKEY, GLOBAL_CONFIG.getApplicationKey());
        HEADERS.put(HEADER_ZCLOUD_REQUEST_FROM_CLOUDCODE, "true");
    }

    static {
        HEADERS = new HashMap<String, String>();
    }
}

