/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.LASException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class LASJsonParser {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeFactory typeFactory = TypeFactory.defaultInstance();

    public static <T> T asObject(String source, Class<T> clazz) {
        try {
            return (T)mapper.readValue(source, typeFactory.uncheckedSimpleType(clazz));
        }
        catch (IOException e) {
            throw new LASException(e);
        }
    }

    public static <T> T asObject(String source, JavaType type) {
        try {
            return (T)mapper.readValue(source, type);
        }
        catch (IOException e) {
            throw new LASException(e);
        }
    }

    public static JsonNode asJsonNode(String source) {
        try {
            return mapper.readTree(source);
        }
        catch (IOException e) {
            throw new LASException(e);
        }
    }

    public static Map<String, Object> objectToMap(Object object) {
        if (object == null) {
            return null;
        }
        try {
            String jsonStr = mapper.writeValueAsString(object);
            return (Map)mapper.readValue(jsonStr, Map.class);
        }
        catch (Exception e) {
            throw new LASException(e);
        }
    }

    public static List asList(String json) {
        return (List)mapper.convertValue((Object)LASJsonParser.asJsonNode(json), List.class);
    }

    public static Map<String, Object> asMap(String json) {
        return (Map)mapper.convertValue((Object)LASJsonParser.asJsonNode(json), Map.class);
    }

    public static Map<String, Object> jsonNodeToMap(JsonNode jsonNode) {
        return (Map)mapper.convertValue((Object)jsonNode, Map.class);
    }

    public static <T> String asJson(T obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new LASException(e);
        }
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

