/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.Definer;
import as.leap.code.LASHandler;
import as.leap.code.Loader;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.Request;
import as.leap.code.Response;
import as.leap.code.impl.DefineFunction;
import as.leap.code.impl.DefineJob;
import as.leap.code.impl.DefineLASClassManager;
import java.util.HashMap;
import java.util.Map;

public abstract class LoaderBase
implements Loader {
    private Logger logger = LoggerFactory.getLogger(LoaderBase.class);
    private Map<String, Definer> definers;
    private Definer functionDefiner = new DefineFunction();
    private Definer jobDefiner = new DefineJob();
    private Definer managerDefiner = new DefineLASClassManager();

    protected LoaderBase() {
        this.definers = new HashMap<String, Definer>();
        this.definers.put(this.functionDefiner.getCategory().alias(), this.functionDefiner);
        this.definers.put(this.jobDefiner.getCategory().alias(), this.jobDefiner);
        this.definers.put(this.managerDefiner.getCategory().alias(), this.managerDefiner);
    }

    @Override
    public Map<String, Definer> definers() {
        return this.definers;
    }

    protected void defineFunction(String name, LASHandler<? extends Request, ? extends Response> handler) {
        this.functionDefiner.define(name, handler);
        this.logger.info("Deployed Cloud Function :" + name);
    }

    protected void defineJob(String name, LASHandler<? extends Request, ? extends Response> handler) {
        this.jobDefiner.define(name, handler);
        this.logger.info("Deployed Cloud Job :" + name);
    }

    void defineClassesManager(String name, LASHandler<? extends Request, ? extends Response> handler) {
        this.managerDefiner.define(name, handler);
        this.logger.info("Deployed Cloud Classes Manager :" + name);
    }
}

