/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.test.framework;

import as.leap.code.ClassManager;
import as.leap.code.LASClassManager;
import as.leap.code.LASClassManagerFactory;
import as.leap.code.LASClassManagerHook;
import as.leap.code.LASException;
import as.leap.code.Loader;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.impl.AssistLASClassManagerImpl;
import as.leap.code.impl.GlobalConfig;
import as.leap.code.impl.LASClassManagerHandler;
import as.leap.code.impl.LASClassManagerHookBase;
import as.leap.code.impl.LASClassManagerImpl;
import as.leap.code.impl.LASJsonParser;
import as.leap.code.impl.LoaderBase;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.file.FileURLConnection;

class BootstrapCloudCode {
    private GlobalConfig globalConfig;
    private static final Logger logger = LoggerFactory.getLogger(BootstrapCloudCode.class);
    private LoaderBase loader;
    private ClassLoader classLoader;
    private Set<Class> hookEntities;
    private Map<String, LASClassManagerHandler> entityManagerHandlerMap = new ConcurrentHashMap<String, LASClassManagerHandler>();
    private String restAddr;

    BootstrapCloudCode() {
    }

    public void setRestAddr(String restAddr) {
        this.restAddr = restAddr;
    }

    public void start() throws Exception {
        this.globalConfig = this.loadConfig();
        this.hookEntities = new HashSet<Class>();
        if (this.globalConfig.getPackageHook() != null && !this.isBlank(this.globalConfig.getPackageHook())) {
            this.loadHookAndManager(this.globalConfig.getPackageHook());
        }
        this.cacheEntity(this.globalConfig);
        AssistLASClassManagerImpl.DEFAULT_API_ADDRESS_PREFIX = this.restAddr;
        this.loadMain(this.globalConfig.getCodeMain());
    }

    private GlobalConfig loadConfig() {
        JsonNode jsonNode = null;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = this.classLoader.getResourceAsStream("config/global.json");
        if (inputStream == null) {
            throw new LASException("you must have a global.json config file for your cloud code.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            StringBuilder globalBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                globalBuilder.append(line);
            }
            jsonNode = LASJsonParser.asJsonNode((String)globalBuilder.toString());
        }
        catch (LASException e) {
            throw new LASException("Your global.json config is not match json format.Please check your config. Caused by " + e.getMessage());
        }
        catch (IOException e) {
            throw new LASException((Throwable)e);
        }
        return new GlobalConfig(jsonNode);
    }

    public LASClassManagerHandler getEntityManagerHandler(String managerName) {
        return this.entityManagerHandlerMap.get(managerName);
    }

    public Loader getLoader() {
        return this.loader;
    }

    private void loadMain(String userMainClassPath) throws Exception {
        Class<?> clazz = Class.forName(userMainClassPath);
        this.loader = (LoaderBase)clazz.newInstance();
        this.loader.main(this.globalConfig);
    }

    private void cacheEntity(GlobalConfig globalConfig) {
        String entityPackage = globalConfig.getPackageEntity();
        if (entityPackage != null && !entityPackage.trim().equals("")) {
            try {
                List<Class<Class>> allEntity = this.getClassesForPackage(this.classLoader, entityPackage);
                if (allEntity.size() == 0) {
                    logger.warn((Object)"Your package-entity is empty.You will can't operate any ZEntityManager interfaces.Please check your global.json config");
                }
                allEntity.removeAll(this.hookEntities);
                for (Class<?> clazz : allEntity) {
                    LASClassManagerImpl entityManager = new LASClassManagerImpl(globalConfig.getApplicationID(), globalConfig.getApplicationKey(), null, clazz, this.restAddr);
                    LASClassManagerFactory.putManager(clazz, (LASClassManager)entityManager);
                    logger.info("cache entity to factory:" + clazz.getSimpleName());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.err.println(e.getMessage());
            }
        } else {
            logger.warn((Object)"Your package-entity is empty.You will can't operate any ZEntityManager interfaces.");
        }
    }

    private void loadHookAndManager(String hookPackage) throws Exception {
        File[] files;
        URL packageRoot = Thread.currentThread().getContextClassLoader().getResource(hookPackage.replace(".", "/"));
        if (packageRoot == null) {
            throw new LASException("your package-hook is invalid.Please check your global.json config");
        }
        for (File file : files = new File(packageRoot.getFile()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        })) {
            String name = file.getName();
            if (!name.endsWith(".class")) continue;
            this.parseClass(hookPackage, name.substring(0, name.length() - 6));
        }
    }

    private void parseClass(String hookPackage, String clazzName) {
        try {
            Class<?> hookClazz = Thread.currentThread().getContextClassLoader().loadClass(hookPackage + "." + clazzName);
            ClassManager classManagerAnnotation = hookClazz.getAnnotation(ClassManager.class);
            if (classManagerAnnotation == null) {
                return;
            }
            String managerName = classManagerAnnotation.value();
            if (managerName.equals("")) {
                String[] managerNames = managerName.split("ManagerHook");
                if (managerNames.length >= 2) {
                    managerName = managerNames[0];
                } else {
                    managerNames = managerName.split("Hook");
                    if (managerNames.length >= 2) {
                        managerName = managerNames[0];
                    } else {
                        throw new IllegalArgumentException(String.format("class %s should be annotate value.", hookClazz.getSimpleName()));
                    }
                }
            }
            LASClassManagerHookBase hook = (LASClassManagerHookBase)hookClazz.newInstance();
            Type[] types = ((ParameterizedType)hookClazz.getGenericSuperclass()).getActualTypeArguments();
            Class entityClazz = (Class)types[0];
            LASClassManagerImpl entityManager = new LASClassManagerImpl(this.globalConfig.getApplicationID(), this.globalConfig.getApplicationKey(), (LASClassManagerHook)hook, entityClazz, this.restAddr);
            this.entityManagerHandlerMap.put(managerName, new LASClassManagerHandler((LASClassManager)entityManager, (LASClassManagerHook)hook, entityClazz));
            LASClassManagerFactory.putManager((Class)entityClazz, (LASClassManager)entityManager);
            logger.info("cache entity to factory:" + entityClazz.getSimpleName());
            this.hookEntities.add(entityClazz);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isBlank(String str) {
        return str == null || str.trim().equals("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Class<?>> getClassesForPackage(ClassLoader cld, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        try {
            URL url;
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(packageName.replace('.', '/'));
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        this.checkJarFile((JarURLConnection)connection, packageName, classes);
                        continue;
                    }
                    if (!(connection instanceof FileURLConnection)) throw new ClassNotFoundException(packageName + " (" + url.getPath() + ") does not appear to be a valid package");
                    try {
                        this.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), packageName, classes);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, e);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioEx) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, ioEx);
        }
    }

    private void checkDirectory(File directory, String packageName, ArrayList<Class<?>> classes) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files;
            for (String file : files = directory.list()) {
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(packageName + '.' + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError e) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory()) continue;
                this.checkDirectory(tmpDirectory, packageName + "." + file, classes);
            }
        }
    }

    private void checkJarFile(JarURLConnection connection, String packageName, ArrayList<Class<?>> classes) throws ClassNotFoundException, IOException {
        JarEntry jarEntry;
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).contains(packageName)) continue;
            classes.add(this.classLoader.loadClass(name));
        }
    }
}

