/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.geom.RectListManager;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.gvt.renderer.StaticRenderer;

public class DynamicRenderer
extends StaticRenderer {
    static final int COPY_OVERHEAD = 1000;
    static final int COPY_LINE_OVERHEAD = 10;
    RectListManager damagedAreas;

    public DynamicRenderer() {
    }

    public DynamicRenderer(RenderingHints renderingHints, AffineTransform affineTransform) {
        super(renderingHints, affineTransform);
    }

    protected CachableRed setupCache(CachableRed cachableRed) {
        return cachableRed;
    }

    public void flush(Rectangle rectangle) {
    }

    public void flush(List list) {
    }

    protected void updateWorkingBuffers() {
        if (this.rootFilter == null) {
            this.rootFilter = this.rootGN.getGraphicsNodeRable(true);
            this.rootCR = null;
        }
        this.rootCR = this.renderGNR();
        if (this.rootCR == null) {
            this.workingRaster = null;
            this.workingOffScreen = null;
            this.workingBaseRaster = null;
            this.currentOffScreen = null;
            this.currentBaseRaster = null;
            this.currentRaster = null;
            return;
        }
        SampleModel sampleModel = this.rootCR.getSampleModel();
        int n = this.offScreenWidth;
        int n2 = this.offScreenHeight;
        if (this.workingBaseRaster == null || this.workingBaseRaster.getWidth() < n || this.workingBaseRaster.getHeight() < n2) {
            sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
            this.workingBaseRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
            this.workingRaster = this.workingBaseRaster.createWritableChild(0, 0, n, n2, 0, 0, null);
            this.workingOffScreen = new BufferedImage(this.rootCR.getColorModel(), this.workingRaster, this.rootCR.getColorModel().isAlphaPremultiplied(), null);
        }
        if (!this.isDoubleBuffered) {
            this.currentOffScreen = this.workingOffScreen;
            this.currentBaseRaster = this.workingBaseRaster;
            this.currentRaster = this.workingRaster;
        }
    }

    public void repaint(List list) {
        Object object;
        Shape shape;
        if (list == null) {
            return;
        }
        this.updateWorkingBuffers();
        if (this.rootCR == null || this.workingBaseRaster == null) {
            return;
        }
        CachableRed cachableRed = this.rootCR;
        WritableRaster writableRaster = this.workingBaseRaster;
        WritableRaster writableRaster2 = this.workingRaster;
        Rectangle rectangle = this.rootCR.getBounds();
        Rectangle rectangle2 = this.workingRaster.getBounds();
        if (rectangle2.x < rectangle.x || rectangle2.y < rectangle.y || rectangle2.x + rectangle2.width > rectangle.x + rectangle.width || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        }
        Rectangle[] rectangleArray = new Rectangle[list.size()];
        Iterator iterator = list.iterator();
        Rectangle rectangle3 = writableRaster2.getBounds();
        float f = 0.0f;
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            int n3;
            int n4;
            shape = (Shape)iterator.next();
            Rectangle2D rectangle2D = (shape = this.usr2dev.createTransformedShape(shape)).getBounds2D();
            int n5 = (int)Math.floor(rectangle2D.getX());
            object = new Rectangle(n5 - 1, (n4 = (int)Math.floor(rectangle2D.getY())) - 1, (n3 = (int)Math.ceil(rectangle2D.getX() + rectangle2D.getWidth())) - n5 + 3, (n2 = (int)Math.ceil(rectangle2D.getY() + rectangle2D.getHeight())) - n4 + 3);
            if (!rectangle3.intersects((Rectangle)object)) continue;
            object = rectangle3.intersection((Rectangle)object);
            rectangleArray[n++] = object;
            f += (float)((Rectangle)object).width * (float)((Rectangle)object).height;
        }
        shape = null;
        try {
            shape = new RectListManager(rectangleArray, 0, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        shape.mergeRects(1000, 10);
        boolean bl = f > (float)(this.offScreenWidth * this.offScreenHeight) * 0.9f;
        WritableRaster writableRaster3 = writableRaster;
        synchronized (writableRaster3) {
            if (bl) {
                cachableRed.copyData(writableRaster2);
            } else {
                Graphics2D graphics2D = null;
                if (this.isDoubleBuffered && this.currentRaster != null && this.damagedAreas != null) {
                    this.damagedAreas.subtract((RectListManager)shape, 1000, 10);
                    this.damagedAreas.mergeRects(1000, 10);
                    iterator = this.damagedAreas.iterator();
                    Rectangle rectangle4 = this.currentRaster.getBounds();
                    while (iterator.hasNext()) {
                        Rectangle rectangle5 = (Rectangle)iterator.next();
                        object = this.currentRaster.createWritableChild(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, rectangle5.x, rectangle5.y, null);
                        GraphicsUtil.copyData((Raster)object, (WritableRaster)writableRaster2);
                        if (graphics2D == null) continue;
                        graphics2D.setPaint(new Color(0, 0, 255, 50));
                        graphics2D.fill(rectangle5);
                        graphics2D.setPaint(new Color(0, 0, 0, 50));
                        graphics2D.draw(rectangle5);
                    }
                }
                iterator = shape.iterator();
                while (iterator.hasNext()) {
                    Rectangle rectangle6 = (Rectangle)iterator.next();
                    WritableRaster writableRaster4 = writableRaster2.createWritableChild(rectangle6.x, rectangle6.y, rectangle6.width, rectangle6.height, rectangle6.x, rectangle6.y, null);
                    cachableRed.copyData(writableRaster4);
                    if (graphics2D == null) continue;
                    graphics2D.setPaint(new Color(255, 0, 0, 50));
                    graphics2D.fill(rectangle6);
                    graphics2D.setPaint(new Color(0, 0, 0, 50));
                    graphics2D.draw(rectangle6);
                }
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        BufferedImage bufferedImage = this.workingOffScreen;
        this.workingBaseRaster = this.currentBaseRaster;
        this.workingRaster = this.currentRaster;
        this.workingOffScreen = this.currentOffScreen;
        this.currentRaster = writableRaster2;
        this.currentBaseRaster = writableRaster;
        this.currentOffScreen = bufferedImage;
        this.damagedAreas = shape;
    }
}

