/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.beantag;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import net.incongru.beantag.BeanTagConfig;
import net.incongru.beantag.Property;
import net.incongru.beantag.PropertyDecorator;
import net.incongru.beantag.PropertyDecoratorException;
import net.incongru.beantag.TableWriter;

public abstract class AbstractTableWriter
implements TableWriter {
    private static final String DEFAULT_EVEN_CLASS = "even";
    private static final String DEFAULT_ODD_CLASS = "odd";
    private int rowCount = 0;
    protected PropertyDecorator propertyDecorator = null;
    private BeanTagConfig config;

    public void setConfig(BeanTagConfig beanTagConfig) {
        this.config = beanTagConfig;
    }

    public Object getValue(String propertyName, Object o) throws PropertyDecoratorException {
        if (propertyName == null) {
            return null;
        }
        return this.lookupValue(propertyName, o);
    }

    protected abstract Object lookupValue(String var1, Object var2) throws PropertyDecoratorException;

    public final void setPropertyDecorator(PropertyDecorator propertyDecorator) {
        this.propertyDecorator = propertyDecorator;
    }

    public void writeHeader(JspWriter out, String label, String htmlTableClass, String htmlTableStyle, String htmlTableId) throws IOException {
        out.print("<table");
        if (htmlTableClass != null) {
            out.print(" class=\"");
            out.print(htmlTableClass);
            out.print("\"");
        }
        if (htmlTableStyle != null) {
            out.print(" style=\"");
            out.print(htmlTableStyle);
            out.print("\"");
        }
        if (htmlTableId != null) {
            out.print(" id=\"");
            out.print(htmlTableId);
            out.print("\"");
        }
        out.println(">");
        if (label != null) {
            out.print("<caption>");
            out.print(label);
            out.println("</caption>");
        }
        out.println("<tbody>");
    }

    public void writeFooter(JspWriter out) throws IOException {
        boolean emptyRow = Boolean.valueOf(this.config.getProperty("emptytable.notice"));
        if (this.rowCount == 0 && emptyRow) {
            out.print("<tr><td colspan=\"2\">");
            out.print(this.translate("beandisplaytag.emptytable.notice"));
            out.println("</td></tr>");
        }
        out.println("</tbody>");
        out.println("</table>");
    }

    public String getLabel(Property p) throws PropertyDecoratorException {
        if (p.getLabel() != null) {
            return p.getLabel();
        }
        return p.getPropertyName();
    }

    public String getRowClass(Property p, Object o) throws PropertyDecoratorException {
        ++this.rowCount;
        if (p.getRowClass() != null) {
            return p.getRowClass();
        }
        return this.rowCount % 2 == 0 ? DEFAULT_EVEN_CLASS : DEFAULT_ODD_CLASS;
    }

    public String getRowStyle(Property p, Object o) throws PropertyDecoratorException {
        return p.getRowStyle();
    }

    public String getLabelClass(Property p, Object o) throws PropertyDecoratorException {
        return p.getLabelClass();
    }

    public String getLabelStyle(Property p, Object o) throws PropertyDecoratorException {
        return p.getLabelStyle();
    }

    public String getValueClass(Property p, Object o) throws PropertyDecoratorException {
        return p.getValueClass();
    }

    public String getValueStyle(Property p, Object o) throws PropertyDecoratorException {
        return p.getValueStyle();
    }

    protected String translate(String text) {
        return text;
    }
}

