/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.beantag;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspWriter;
import net.incongru.beantag.BeanTagConfig;
import net.incongru.beantag.Property;
import net.incongru.beantag.PropertyDecorator;
import net.incongru.beantag.PropertyDecoratorException;
import net.incongru.beantag.TableWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableWriter
implements TableWriter {
    private static final String DEFAULT_EVEN_CLASS = "even";
    private static final String DEFAULT_ODD_CLASS = "odd";
    private int rowCount = 0;
    protected PropertyDecorator propertyDecorator = null;
    private BeanTagConfig config;

    @Override
    public void setConfig(BeanTagConfig beanTagConfig) {
        this.config = beanTagConfig;
    }

    @Override
    public Object getValue(String propertyName, Object o) throws PropertyDecoratorException {
        if (propertyName == null) {
            return null;
        }
        return this.lookupValue(propertyName, o);
    }

    protected abstract Object lookupValue(String var1, Object var2) throws PropertyDecoratorException;

    @Override
    public List getAllProperties(Object o) throws PropertyDecoratorException {
        List<Object> propNames;
        LinkedList<Property> props = new LinkedList<Property>();
        if (o instanceof Map) {
            propNames = new LinkedList();
            Set mapKeys = ((Map)o).keySet();
            for (Object mapKey : mapKeys) {
                propNames.add(String.valueOf(mapKey));
            }
        } else {
            propNames = this.getAllPropertyNames(o);
        }
        Collections.sort(propNames);
        for (String string : propNames) {
            props.add(new Property(this.getValue(string, o), string, string, null, null, null));
        }
        return props;
    }

    protected abstract List<String> getAllPropertyNames(Object var1);

    @Override
    public final void setPropertyDecorator(PropertyDecorator propertyDecorator) {
        this.propertyDecorator = propertyDecorator;
    }

    @Override
    public void writeHeader(JspWriter out, String label, String htmlTableClass, String htmlTableStyle, String htmlTableId) throws IOException {
        out.print("<table");
        if (htmlTableClass != null) {
            out.print(" class=\"");
            out.print(htmlTableClass);
            out.print("\"");
        }
        if (htmlTableStyle != null) {
            out.print(" style=\"");
            out.print(htmlTableStyle);
            out.print("\"");
        }
        if (htmlTableId != null) {
            out.print(" id=\"");
            out.print(htmlTableId);
            out.print("\"");
        }
        out.println(">");
        if (label != null) {
            out.print("<caption>");
            out.print(label);
            out.println("</caption>");
        }
        out.println("<tbody>");
    }

    @Override
    public void writeFooter(JspWriter out) throws IOException {
        boolean emptyRow = Boolean.valueOf(this.config.getProperty("emptytable.notice"));
        if (this.rowCount == 0 && emptyRow) {
            out.print("<tr><td colspan=\"2\">");
            out.print(this.translate("beandisplaytag.emptytable.notice"));
            out.println("</td></tr>");
        }
        out.println("</tbody>");
        out.println("</table>");
    }

    @Override
    public String getLabel(Property p) throws PropertyDecoratorException {
        if (p.getLabel() != null) {
            return p.getLabel();
        }
        return p.getPropertyName();
    }

    @Override
    public String getRowClass(Property p, Object o) throws PropertyDecoratorException {
        ++this.rowCount;
        if (p.getRowClass() != null) {
            return p.getRowClass();
        }
        return this.rowCount % 2 == 0 ? DEFAULT_EVEN_CLASS : DEFAULT_ODD_CLASS;
    }

    @Override
    public String getRowStyle(Property p, Object o) throws PropertyDecoratorException {
        return p.getRowStyle();
    }

    @Override
    public String getLabelClass(Property p, Object o) throws PropertyDecoratorException {
        return p.getLabelClass();
    }

    @Override
    public String getLabelStyle(Property p, Object o) throws PropertyDecoratorException {
        return p.getLabelStyle();
    }

    @Override
    public String getValueClass(Property p, Object o) throws PropertyDecoratorException {
        return p.getValueClass();
    }

    @Override
    public String getValueStyle(Property p, Object o) throws PropertyDecoratorException {
        return p.getValueStyle();
    }

    protected String translate(String text) {
        return text;
    }
}

