/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.beantag;

import java.beans.IntrospectionException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.incongru.beantag.AbstractTableWriter;
import net.incongru.beantag.PropertyDecoratorException;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlTableWriter
extends AbstractTableWriter {
    private static final Logger logger = Logger.getLogger(OgnlTableWriter.class);

    @Override
    protected Object lookupValue(String propertyName, Object o) throws PropertyDecoratorException {
        try {
            Object value = null;
            Object ognlExpr = Ognl.parseExpression((String)propertyName);
            if (this.propertyDecorator != null) {
                this.propertyDecorator.setCurrentItem(o);
                try {
                    value = Ognl.getValue((Object)ognlExpr, (Object)this.propertyDecorator);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
            }
            if (value == null) {
                value = Ognl.getValue((Object)ognlExpr, (Object)o);
            }
            return value;
        }
        catch (OgnlException e) {
            logger.warn((Object)("Can't get property[" + propertyName + "] for [" + o + "]: " + ((Object)((Object)e)).getClass() + " : " + e.getMessage()));
            return null;
        }
    }

    @Override
    public boolean evaluate(String expr, Object o) {
        try {
            Object ognlExpr = Ognl.parseExpression((String)expr);
            Boolean result = (Boolean)Ognl.getValue((Object)ognlExpr, (Object)o, Boolean.class);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (OgnlException e) {
            logger.warn((Object)("Can't evaluate expression[" + expr + "]"), (Throwable)e);
            return false;
        }
    }

    @Override
    protected List<String> getAllPropertyNames(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        try {
            Map propsDescs = OgnlRuntime.getPropertyDescriptors(o.getClass());
            return new LinkedList<String>(propsDescs.keySet());
        }
        catch (OgnlException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}

