/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.bookmarksmgt;

import com.opensymphony.xwork.ActionSupport;
import net.incongru.berkano.bookmarks.Bookmark;
import net.incongru.berkano.bookmarks.BookmarksTree;
import net.incongru.berkano.bookmarks.ExternalBookmark;
import net.incongru.berkano.user.UnknownUserException;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.UserDAO;
import net.incongru.berkano.user.extensions.BookmarksDAO;

public class AddUserBookmarksAction
extends ActionSupport {
    private UserDAO userDAO;
    private BookmarksDAO bookmarksDAO;
    private Long userId;
    private int bookmarkId;
    private String url;
    private String description;
    private String longDescription;
    private Bookmark bookmark;

    public AddUserBookmarksAction(UserDAO userDAO, BookmarksDAO bookmarksDAO) {
        this.userDAO = userDAO;
        this.bookmarksDAO = bookmarksDAO;
    }

    public String execute() throws UnknownUserException {
        if (this.bookmarkId <= 0 || this.url == null || this.userId == null) {
            return "error";
        }
        if (this.description == null) {
            this.description = this.url;
        }
        if (this.longDescription == null) {
            this.longDescription = this.description;
        }
        User user = this.userDAO.getUserById(this.userId);
        BookmarksTree bookmarks = this.bookmarksDAO.getUserBookmarks(user);
        this.bookmark = new ExternalBookmark(this.bookmarkId, this.url, this.description, this.longDescription);
        bookmarks.add(this.bookmark, null);
        throw new IllegalStateException("to be reimplemented");
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public int getBookmarkId() {
        return this.bookmarkId;
    }

    public void setBookmarkId(int bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }
}

