/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.security.seraph.taglib;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import net.incongru.security.seraph.taglib.AbstractSecurityTag;

public class SecuredLinkTag
extends AbstractSecurityTag {
    private String href;
    private String title;
    private String cssClass;
    private String onclick;
    private boolean alwaysOutputBody = false;
    private boolean includeContext = true;

    public void setHref(String href) {
        this.href = href;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setAlwaysOutputBody(boolean alwaysOutputBody) {
        this.alwaysOutputBody = alwaysOutputBody;
    }

    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    public void doTag() throws JspException, IOException {
        boolean granted = this.isUserAllowedPath(this.href);
        if (granted) {
            this.outputLink();
        } else if (this.alwaysOutputBody) {
            this.outputBody();
        }
    }

    private void outputLink() throws IOException, JspException {
        JspWriter out = this.getJspContext().getOut();
        out.write("<a href=\"");
        if (this.href.startsWith("/") && this.includeContext) {
            out.write(this.getRequest().getContextPath());
        }
        out.write(this.href);
        out.write("\"");
        if (this.title != null) {
            out.write(" title=\"");
            out.write(this.title);
            out.write("\"");
        }
        if (this.cssClass != null) {
            out.write(" class=\"");
            out.write(this.cssClass);
            out.write("\"");
        }
        if (this.onclick != null) {
            out.write(" onclick=\"");
            out.write(this.onclick);
            out.write("\"");
        }
        out.write(">");
        this.outputBody(out);
        out.write("</a>");
    }
}

