/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.bookmarksmgt;

import com.atlassian.seraph.auth.AuthenticationContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.incongru.berkano.bookmarks.Bookmark;
import net.incongru.berkano.bookmarks.BookmarksTree;
import net.incongru.berkano.bookmarks.ExternalBookmark;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.extensions.BookmarksDAO;

public class UserBookmarksAccessor
extends ActionSupport {
    protected static final String USER_BOOKMARKS = "berkano.user.bookmarks";
    protected static final String DEFAULT_BOOKMARKS = "berkano.app.default.bookmarks";
    private AuthenticationContext authenticationContext;
    private BookmarksDAO bookmarksDAO;

    public UserBookmarksAccessor(AuthenticationContext authenticationContext, BookmarksDAO bookmarksDAO) {
        this.authenticationContext = authenticationContext;
        this.bookmarksDAO = bookmarksDAO;
    }

    public BookmarksTree getSelfBookmarks() {
        User user = (User)this.authenticationContext.getUser();
        if (user == null) {
            return this.getDefaultBookmarks();
        }
        Map session = ActionContext.getContext().getSession();
        BookmarksTree bookmarks = (BookmarksTree)session.get(USER_BOOKMARKS);
        if (bookmarks == null) {
            bookmarks = this.bookmarksDAO.getUserBookmarks(user);
            if (bookmarks == null) {
                bookmarks = this.getDefaultBookmarks();
            }
            session.put(USER_BOOKMARKS, bookmarks);
        }
        return bookmarks;
    }

    private BookmarksTree getDefaultBookmarks() {
        Map app = ActionContext.getContext().getApplication();
        BookmarksTree bookmarks = (BookmarksTree)app.get(DEFAULT_BOOKMARKS);
        if (bookmarks == null) {
            bookmarks = this.loadDefaultBookmarks();
            app.put(DEFAULT_BOOKMARKS, bookmarks);
        }
        return bookmarks;
    }

    protected BookmarksTree loadDefaultBookmarks() {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/bookmarks.default");
        if (in == null) {
            throw new RuntimeException("Can't open /bookmarks.default");
        }
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't load /bookmarks.default : " + e.getMessage(), e);
        }
        BookmarksTree tree = new BookmarksTree();
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            ExternalBookmark b = new ExternalBookmark(i, (String)entry.getValue(), (String)entry.getKey(), null);
            tree.add((Bookmark)b, null);
            ++i;
        }
        return tree;
    }
}

