/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import net.incongru.berkano.user.Group;
import net.incongru.berkano.user.GroupDAO;
import net.incongru.berkano.user.GroupImpl;
import net.incongru.berkano.user.PropertiesAware;
import net.incongru.berkano.user.UnknownUserException;
import net.incongru.berkano.user.hibernate.AbstractHibernatedDAO;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;

public class HibernatedGroupDAO
extends AbstractHibernatedDAO
implements GroupDAO {
    public HibernatedGroupDAO(Session session) {
        super(session);
    }

    protected PropertiesAware getById(Long id) throws UnknownUserException {
        return (PropertiesAware)((Object)this.getGroupById(id));
    }

    public Group getGroupById(Long groupId) {
        try {
            return (Group)this.session.get(GroupImpl.class, (Serializable)groupId);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public Group getGroupByName(String groupName) {
        throw new RuntimeException("not implemented yet");
    }

    public Group newGroup(String groupName) {
        try {
            GroupImpl g = new GroupImpl();
            g.setGroupName(groupName);
            this.session.save((Object)g);
            return g;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removeGroup(Long groupId) {
        try {
            Object group = this.session.load(GroupImpl.class, (Serializable)groupId);
            this.session.delete(group);
            return true;
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public List listAllGroups() {
        try {
            return this.session.createCriteria(GroupImpl.class).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }

    public void assignRoles(Long groupId, Set roles) {
        try {
            GroupImpl g = (GroupImpl)this.getGroupById(groupId);
            g.setRoles(roles);
            this.session.save((Object)g);
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
    }
}

